/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.inventoryapi;

import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kayteam.inventoryapi.GetItem;
import org.kayteam.inventoryapi.action.CloseAction;
import org.kayteam.inventoryapi.action.SlotAction;

public class InventoryBuilder {
    private Inventory inventory;
    private final String title;
    private final int rows;
    private final int updateInterval;
    private final HashMap<Integer, GetItem> items = new HashMap();
    private final HashMap<Integer, Boolean> updateItems = new HashMap();
    private final HashMap<Integer, SlotAction> leftActions = new HashMap();
    private final HashMap<Integer, SlotAction> rightActions = new HashMap();
    private final HashMap<Integer, SlotAction> middleActions = new HashMap();
    private final HashMap<Integer, SlotAction> leftShiftActions = new HashMap();
    private final HashMap<Integer, SlotAction> rightShiftActions = new HashMap();
    private CloseAction closeAction;

    public InventoryBuilder() {
        this.title = "Default Title";
        this.rows = 3;
        this.updateInterval = 0;
    }

    public InventoryBuilder(String title) {
        this.title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        this.rows = 3;
        this.updateInterval = 0;
    }

    public InventoryBuilder(String title, int rows) {
        this.title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        this.rows = rows;
        this.updateInterval = 0;
    }

    public InventoryBuilder(String title, int rows, int updateInterval) {
        this.title = ChatColor.translateAlternateColorCodes((char)'&', (String)title);
        this.rows = rows;
        this.updateInterval = updateInterval;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public String getTitle() {
        return this.title;
    }

    public int getRows() {
        return this.rows;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void fillItem(GetItem getItem) {
        for (int i = 0; i < this.rows * 9; ++i) {
            if (this.items.containsKey(i)) continue;
            this.items.put(i, getItem);
        }
    }

    public void fillItem(GetItem getItem, int[] fillRows) {
        for (int row : fillRows) {
            for (int i = row * 9 - 9; i < row * 9; ++i) {
                this.addItem(i, getItem);
            }
        }
    }

    public void fillItem(GetItem getItem, int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.addItem(i, getItem);
        }
    }

    public boolean containItem(int slot) {
        return this.items.containsKey(slot);
    }

    public void addItem(int slot, GetItem getItem) {
        this.items.put(slot, getItem);
    }

    public GetItem getItem(int slot) {
        return this.items.get(slot);
    }

    public void removeItem(int slot) {
        this.items.remove(slot);
    }

    public HashMap<Integer, Boolean> getUpdateItems() {
        return this.updateItems;
    }

    public boolean isUpdateItem(int slot) {
        if (this.updateItems.containsKey(slot)) {
            return this.updateItems.get(slot);
        }
        return false;
    }

    public void setUpdateItem(int slot, boolean value) {
        this.updateItems.put(slot, value);
    }

    public void removeUpdateItem(int slot) {
        this.updateItems.remove(slot);
    }

    public boolean containLeftAction(int slot) {
        return this.leftActions.containsKey(slot);
    }

    public void addLeftAction(int slot, SlotAction action) {
        this.leftActions.put(slot, action);
    }

    public SlotAction getLeftAction(int slot) {
        return this.leftActions.get(slot);
    }

    public void removeLeftAction(int slot) {
        this.leftActions.remove(slot);
    }

    public boolean containRightAction(int slot) {
        return this.rightActions.containsKey(slot);
    }

    public void addRightAction(int slot, SlotAction action) {
        this.rightActions.put(slot, action);
    }

    public SlotAction getRightAction(int slot) {
        return this.rightActions.get(slot);
    }

    public void removeRightAction(int slot) {
        this.rightActions.remove(slot);
    }

    public boolean containMiddleAction(int slot) {
        return this.middleActions.containsKey(slot);
    }

    public void addMiddleAction(int slot, SlotAction action) {
        this.middleActions.put(slot, action);
    }

    public SlotAction getMiddleAction(int slot) {
        return this.middleActions.get(slot);
    }

    public void removeMiddleAction(int slot) {
        this.middleActions.remove(slot);
    }

    public boolean containLeftShiftAction(int slot) {
        return this.leftShiftActions.containsKey(slot);
    }

    public void addLeftShiftAction(int slot, SlotAction action) {
        this.leftShiftActions.put(slot, action);
    }

    public SlotAction getLeftShiftAction(int slot) {
        return this.leftShiftActions.get(slot);
    }

    public void removeLeftShiftAction(int slot) {
        this.leftShiftActions.remove(slot);
    }

    public boolean containRightShiftAction(int slot) {
        return this.rightShiftActions.containsKey(slot);
    }

    public void addRightShiftAction(int slot, SlotAction action) {
        this.rightShiftActions.put(slot, action);
    }

    public SlotAction getRightShiftAction(int slot) {
        return this.rightShiftActions.get(slot);
    }

    public void removeRightShiftAction(int slot) {
        this.rightShiftActions.remove(slot);
    }

    public void setCloseAction(CloseAction closeAction) {
        this.closeAction = closeAction;
    }

    public CloseAction getCloseAction() {
        if (this.closeAction != null) {
            return this.closeAction;
        }
        return player -> {};
    }

    public void onReload() {
        for (int slot = 0; slot < this.rows * 9; ++slot) {
            GetItem getItem = this.getItem(slot);
            if (getItem == null) continue;
            ItemStack itemStack = getItem.getItem();
            this.inventory.setItem(slot, itemStack);
        }
    }
}

