/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.inventoryapi;

import java.util.ArrayList;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Item {
    private final ItemStack itemStack;
    private final boolean update;
    private final String displayName;
    private final List<String> lore;

    public Item(ItemStack itemStack, boolean update, String displayName, List<String> lore) {
        this.itemStack = itemStack;
        this.update = update;
        this.displayName = displayName;
        this.lore = lore;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void updateItem(Player player) {
        this.applyLore(player);
        this.applyDisplayName(player);
    }

    private void applyLore(Player player) {
        try {
            ArrayList<String> newLore = new ArrayList<String>();
            for (String line : this.lore) {
                line = this.applyPlaceholders(player, line);
                line = ChatColor.translateAlternateColorCodes((char)'&', (String)line);
                newLore.add(line);
            }
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.setLore(newLore);
            this.itemStack.setItemMeta(itemMeta);
        }
        catch (Exception e) {
            Bukkit.getLogger().info("Error applying lore to item: " + e.getMessage());
        }
    }

    private void applyDisplayName(Player player) {
        try {
            String newDisplayName = this.displayName;
            newDisplayName = this.applyPlaceholders(player, newDisplayName);
            newDisplayName = ChatColor.translateAlternateColorCodes((char)'&', (String)newDisplayName);
            ItemMeta itemMeta = this.itemStack.getItemMeta();
            itemMeta.setDisplayName(newDisplayName);
            this.itemStack.setItemMeta(itemMeta);
        }
        catch (Exception e) {
            Bukkit.getLogger().info("Error applying display name to item: " + e.getMessage());
        }
    }

    private String applyPlaceholders(Player player, String text) {
        if (player != null && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }
}

