/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.nbtapi;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.kayteam.nbtapi.NBTCompound;
import org.kayteam.nbtapi.NBTPersistentDataContainer;
import org.kayteam.nbtapi.NBTReflectionUtil;
import org.kayteam.nbtapi.NbtApiException;
import org.kayteam.nbtapi.utils.MinecraftVersion;
import org.kayteam.nbtapi.utils.annotations.AvailableSince;
import org.kayteam.nbtapi.utils.annotations.CheckUtil;
import org.kayteam.nbtapi.utils.annotations.FAUtil;

public class NBTEntity
extends NBTCompound {
    private final Entity ent;

    public NBTEntity(Entity entity) {
        super(null, null);
        if (entity == null) {
            throw new NullPointerException("Entity can't be null!");
        }
        this.ent = entity;
    }

    @Override
    public Object getCompound() {
        if (!Bukkit.isPrimaryThread()) {
            throw new NbtApiException("Entity NBT needs to be accessed sync!");
        }
        return NBTReflectionUtil.getEntityNBTTagCompound(NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @Override
    protected void setCompound(Object compound) {
        if (!Bukkit.isPrimaryThread()) {
            throw new NbtApiException("Entity NBT needs to be accessed sync!");
        }
        NBTReflectionUtil.setEntityNBTTag(compound, NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @AvailableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        return new NBTPersistentDataContainer(this.ent.getPersistentDataContainer());
    }
}

