/*
 * Decompiled with CFR 0.152.
 */
package org.kayteam.storageapi.storage;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class Storage {
    private final JavaPlugin javaPlugin;
    private final String directory;
    private final String fileName;
    private File file;
    private static final HashMap<String, String> globalReplacements = new HashMap();
    private final HashMap<String, String> replacements = new HashMap();

    public Storage(JavaPlugin javaPlugin, String directory, String fileName) {
        this.javaPlugin = javaPlugin;
        this.directory = javaPlugin.getDataFolder().getPath() + File.separator + directory;
        this.fileName = fileName;
    }

    public Storage(JavaPlugin javaPlugin, String fileName) {
        this.javaPlugin = javaPlugin;
        this.directory = javaPlugin.getDataFolder().getPath();
        this.fileName = fileName;
    }

    public Storage(String directory, String fileName) {
        this.javaPlugin = null;
        this.directory = directory;
        this.fileName = fileName;
    }

    public JavaPlugin getJavaPlugin() {
        return this.javaPlugin;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public abstract void register();

    public abstract void reload();

    public abstract void save();

    public abstract boolean delete();

    public abstract void createBackup();

    public abstract boolean contains(String var1);

    public abstract void set(String var1, Object var2);

    public abstract Object get(String var1);

    public abstract Object get(String var1, Object var2);

    public abstract Object get(String var1, Object var2, boolean var3);

    public abstract boolean isBoolean(String var1);

    public abstract boolean getBoolean(String var1);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract boolean getBoolean(String var1, boolean var2, boolean var3);

    public abstract void setBoolean(String var1, boolean var2);

    public abstract boolean isInt(String var1);

    public abstract int getInt(String var1);

    public abstract int getInt(String var1, int var2);

    public abstract int getInt(String var1, int var2, boolean var3);

    public abstract void setInt(String var1, int var2);

    public abstract boolean isLong(String var1);

    public abstract long getLong(String var1);

    public abstract long getLong(String var1, long var2);

    public abstract long getLong(String var1, long var2, boolean var4);

    public abstract void setLong(String var1, long var2);

    public abstract boolean isDouble(String var1);

    public abstract double getDouble(String var1);

    public abstract double getDouble(String var1, double var2);

    public abstract double getDouble(String var1, double var2, boolean var4);

    public abstract void setDouble(String var1, double var2);

    public abstract boolean isString(String var1);

    public abstract String getString(String var1);

    public abstract String getString(String var1, String var2);

    public abstract String getString(String var1, String var2, boolean var3);

    public abstract void setString(String var1, String var2);

    public abstract boolean isStringList(String var1);

    public abstract List<String> getStringList(String var1);

    public abstract List<String> getStringList(String var1, List<String> var2);

    public abstract List<String> getStringList(String var1, List<String> var2, boolean var3);

    public abstract void setStringList(String var1, List<String> var2);

    public abstract boolean isLocation(String var1);

    public abstract Location getLocation(String var1);

    public abstract Location getLocation(String var1, Location var2);

    public abstract Location getLocation(String var1, Location var2, boolean var3);

    public abstract void setLocation(String var1, Location var2);

    public abstract boolean isItemStack(String var1);

    public abstract ItemStack getItemStack(String var1);

    public abstract ItemStack getItemStack(String var1, ItemStack var2);

    public abstract ItemStack getItemStack(String var1, ItemStack var2, boolean var3);

    public abstract void setItemStack(String var1, ItemStack var2);

    public static HashMap<String, String> getGlobalReplacements() {
        return globalReplacements;
    }

    public HashMap<String, String> getReplacements() {
        return this.replacements;
    }
}

