/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.reflectionrewriter;

import io.papermc.asm.rules.RewriteRule;
import java.lang.constant.ClassDesc;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;
import java.util.function.Consumer;

public final class BaseReflectionRules {
    private final ClassDesc proxy;
    private final RewriteRule classRule;
    private final RewriteRule methodHandlesLookupRule;
    private final RewriteRule lambdaMetafactoryRule;
    private final RewriteRule constantBootstrapsRule;
    private final RewriteRule methodTypeRule;

    public BaseReflectionRules(String proxyClassName) {
        this.proxy = ClassDesc.of(proxyClassName);
        this.classRule = this.createClassRule();
        this.methodHandlesLookupRule = this.createMethodHandlesLookupRule();
        this.lambdaMetafactoryRule = this.createLamdaMetafactoryRule();
        this.constantBootstrapsRule = this.createConstantBootstrapsRule();
        this.methodTypeRule = this.createMethodTypeRule();
    }

    public RewriteRule classRule() {
        return this.classRule;
    }

    public RewriteRule methodHandlesLookupRule() {
        return this.methodHandlesLookupRule;
    }

    public RewriteRule lambdaMetafactoryRule() {
        return this.lambdaMetafactoryRule;
    }

    public RewriteRule constantBootstrapsRule() {
        return this.constantBootstrapsRule;
    }

    public RewriteRule methodTypeRule() {
        return this.methodTypeRule;
    }

    public List<RewriteRule> rules() {
        return List.of(this.classRule, this.methodHandlesLookupRule, this.lambdaMetafactoryRule, this.constantBootstrapsRule, this.methodTypeRule);
    }

    private RewriteRule createClassRule() {
        return RewriteRule.forOwnerClass(Class.class, rf -> rf.plainStaticRewrite(this.proxy, b -> b.match("forName").desc(new String[]{"(Ljava/lang/String;)Ljava/lang/Class;"}).match(new String[]{"getField", "getDeclaredField"}).desc(new String[]{"(Ljava/lang/String;)Ljava/lang/reflect/Field;"}).match(new String[]{"getMethod", "getDeclaredMethod"}).desc(new String[]{"(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"})), (Consumer[])new Consumer[0]);
    }

    private RewriteRule createMethodHandlesLookupRule() {
        return RewriteRule.forOwnerClass(MethodHandles.Lookup.class, rf -> rf.plainStaticRewrite(this.proxy, b -> b.match(new String[]{"findStatic", "findVirtual"}).desc(new String[]{"(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;"}).match("findClass").desc(new String[]{"(Ljava/lang/String;)Ljava/lang/Class;"}).match("findSpecial").desc(new String[]{"(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;"}).match(new String[]{"findGetter", "findSetter", "findStaticGetter", "findStaticSetter"}).desc(new String[]{"(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/MethodHandle;"}).match(new String[]{"findVarHandle", "findStaticVarHandle"}).desc(new String[]{"(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;"}).match("bind").desc(new String[]{"(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/MethodHandle;"})), (Consumer[])new Consumer[0]);
    }

    private RewriteRule createLamdaMetafactoryRule() {
        return RewriteRule.forOwnerClass(LambdaMetafactory.class, rf -> rf.plainStaticRewrite(this.proxy, b -> b.match("metafactory").desc(new String[]{"(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;"}).match("altMetafactory").desc(new String[]{"(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;"})), (Consumer[])new Consumer[0]);
    }

    private RewriteRule createConstantBootstrapsRule() {
        return RewriteRule.forOwnerClass(ConstantBootstraps.class, rf -> rf.plainStaticRewrite(this.proxy, b -> b.match("getStaticFinal").desc(new String[]{"(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;"}).match(new String[]{"fieldVarHandle", "staticFieldVarHandle"}).desc(new String[]{"(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/invoke/VarHandle;"})), (Consumer[])new Consumer[0]);
    }

    private RewriteRule createMethodTypeRule() {
        return RewriteRule.forOwnerClass(MethodType.class, rf -> rf.plainStaticRewrite(this.proxy, b -> b.match("fromMethodDescriptorString").desc(new String[]{"(Ljava/lang/String;Ljava/lang/ClassLoader;)Ljava/lang/invoke/MethodType;"})), (Consumer[])new Consumer[0]);
    }
}

