/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.folia;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import net.skinsrestorer.bukkit.utils.SchedulerProvider;
import net.skinsrestorer.shadow.javax.inject.Inject;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FoliaSchedulerProvider
implements SchedulerProvider {
    private final Server server;
    private final JavaPlugin plugin;

    public static boolean isAvailable() {
        try {
            Server.class.getMethod("getAsyncScheduler", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.server.getAsyncScheduler().runNow((Plugin)this.plugin, this.getCancellingTaskConsumer(runnable));
    }

    @Override
    public void runSync(Runnable runnable) {
        this.server.getGlobalRegionScheduler().run((Plugin)this.plugin, this.getCancellingTaskConsumer(runnable));
    }

    @Override
    public void runSyncDelayed(Runnable runnable, long ticks) {
        this.server.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, this.getCancellingTaskConsumer(runnable), ticks);
    }

    @Override
    public void runSyncToEntity(Entity entity, Runnable runnable) {
        entity.getScheduler().run((Plugin)this.plugin, this.getCancellingTaskConsumer(runnable), null);
    }

    @Override
    public void runSyncToEntityDelayed(Entity entity, Runnable runnable, long ticks) {
        entity.getScheduler().runDelayed((Plugin)this.plugin, this.getCancellingTaskConsumer(runnable), null, ticks);
    }

    @Override
    public void runRepeatAsync(Runnable runnable, int delay, int interval, TimeUnit timeUnit) {
        this.server.getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, this.getCancellingTaskConsumer(runnable), (long)delay, (long)interval, timeUnit);
    }

    @Override
    public void unregisterTasks() {
        this.server.getAsyncScheduler().cancelTasks((Plugin)this.plugin);
        this.server.getGlobalRegionScheduler().cancelTasks((Plugin)this.plugin);
    }

    private Consumer<ScheduledTask> getCancellingTaskConsumer(Runnable runnable) {
        return scheduledTask -> {
            if (this.plugin.isEnabled()) {
                runnable.run();
            } else {
                scheduledTask.cancel();
            }
        };
    }

    @Inject
    @Generated
    public FoliaSchedulerProvider(Server server, JavaPlugin plugin) {
        this.server = server;
        this.plugin = plugin;
    }
}

