/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.gui;

import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import net.skinsrestorer.bukkit.gui.BukkitGUIHolder;
import net.skinsrestorer.bukkit.utils.SkullUtil;
import net.skinsrestorer.bukkit.wrapper.BukkitComponentHelper;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_U_S_Stream;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import net.skinsrestorer.shadow.xseries.XEnchantment;
import net.skinsrestorer.shadow.xseries.XMaterial;
import net.skinsrestorer.shared.gui.GUIManager;
import net.skinsrestorer.shared.gui.SRInventory;
import org.bukkit.Server;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class BukkitGUI
implements GUIManager<Inventory> {
    private final Injector injector;
    private final Server server;

    private ItemStack createItem(SRInventory.Item entry) {
        XMaterial xMaterial;
        switch (entry.materialType()) {
            default: {
                throw new J_L_MatchException(null, null);
            }
            case SKULL: {
                xMaterial = XMaterial.PLAYER_HEAD;
                break;
            }
            case ARROW: {
                xMaterial = XMaterial.ARROW;
                break;
            }
            case BARRIER: {
                xMaterial = XMaterial.BARRIER.or(XMaterial.RED_WOOL);
                break;
            }
            case BOOKSHELF: {
                xMaterial = XMaterial.BOOKSHELF;
                break;
            }
            case ENDER_EYE: {
                xMaterial = XMaterial.ENDER_EYE;
                break;
            }
            case ENCHANTING_TABLE: {
                xMaterial = XMaterial.ENCHANTING_TABLE;
            }
        }
        XMaterial material = xMaterial;
        ItemStack itemStack = Objects.requireNonNull(material.parseItem());
        entry.textureHash().ifPresent(hash -> SkullUtil.setSkull(itemStack, hash));
        ItemMeta skullMeta = Objects.requireNonNull(itemStack.getItemMeta());
        skullMeta.setDisplayName(BukkitComponentHelper.toStupidHex(entry.displayName()));
        skullMeta.setLore(J_U_S_Stream.toList(entry.lore().stream().map(BukkitComponentHelper::toStupidHex)));
        if (entry.enchantmentGlow()) {
            skullMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            skullMeta.addEnchant(Objects.requireNonNull((Enchantment)XEnchantment.LURE.get()), 1, true);
        }
        itemStack.setItemMeta(skullMeta);
        return itemStack;
    }

    @Override
    public Inventory createGUI(SRInventory srInventory) {
        BukkitGUIHolder instance = this.injector.newInstance(BukkitGUIHolder.class);
        Inventory inventory = this.server.createInventory((InventoryHolder)instance, srInventory.rows() * 9, BukkitComponentHelper.toStupidHex(srInventory.title()));
        instance.setInventory(inventory);
        for (Map.Entry<Integer, SRInventory.Item> entry : srInventory.items().entrySet()) {
            inventory.setItem(entry.getKey().intValue(), this.createItem(entry.getValue()));
            instance.getHandlers().put(entry.getKey(), entry.getValue().clickHandlers());
        }
        return inventory;
    }

    @Inject
    @Generated
    public BukkitGUI(Injector injector, Server server) {
        this.injector = injector;
        this.server = server;
    }
}

