/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.mappings;

import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.CommonPlayerSpawnInfo;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.effect.MobEffectInstance;
import net.skinsrestorer.bukkit.mappings.IMapping;
import net.skinsrestorer.bukkit.mappings.ViaPacketData;
import net.skinsrestorer.bukkit.utils.ExceptionSupplier;
import net.skinsrestorer.bukkit.utils.HandleReflection;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_List;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Set;
import org.bukkit.entity.Player;

public class Mapping1_21_2
implements IMapping {
    private static void sendPacket(ServerPlayer player, Packet<?> packet) {
        player.connection.send(packet);
    }

    @Override
    public void accept(Player player, Predicate<ExceptionSupplier<ViaPacketData>> viaFunction) {
        ServerPlayer entityPlayer = HandleReflection.getHandle(player, ServerPlayer.class);
        ServerLevel world = entityPlayer.y();
        CommonPlayerSpawnInfo spawnInfo = entityPlayer.createCommonSpawnInfo(world);
        ClientboundRespawnPacket respawn = new ClientboundRespawnPacket(spawnInfo, 3);
        this.resendInfoPackets(player, player);
        if (viaFunction.test(() -> new ViaPacketData(player, spawnInfo.seed(), spawnInfo.gameType().getId(), spawnInfo.isFlat()))) {
            Mapping1_21_2.sendPacket(entityPlayer, respawn);
        }
        entityPlayer.x();
        entityPlayer.connection.teleport(player.getLocation());
        entityPlayer.completeUsingItem();
        PlayerList playerList = entityPlayer.server.getPlayerList();
        playerList.sendPlayerPermissionLevel(entityPlayer);
        playerList.sendLevelInfo(entityPlayer, world);
        playerList.sendAllPlayerInfo(entityPlayer);
        for (MobEffectInstance effect : entityPlayer.eB()) {
            Mapping1_21_2.sendPacket(entityPlayer, new ClientboundUpdateMobEffectPacket(entityPlayer.ar(), effect, false));
        }
    }

    @Override
    public void resendInfoPackets(Player toResend, Player toSendTo) {
        ServerPlayer toResendInternal = HandleReflection.getHandle(toResend, ServerPlayer.class);
        ServerPlayer toSendToInternal = HandleReflection.getHandle(toSendTo, ServerPlayer.class);
        Mapping1_21_2.sendPacket(toSendToInternal, new ClientboundPlayerInfoRemovePacket(J_U_List.of(toResendInternal.getUUID())));
        Mapping1_21_2.sendPacket(toSendToInternal, ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(J_U_List.of(toResendInternal)));
    }

    @Override
    public Set<String> getSupportedVersions() {
        return J_U_Set.of("ec8b033a89c54252f1dfcb809eab710a", "61a218cda78417b6039da56e08194083");
    }
}

