/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.cache;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@API(status=API.Status.STABLE, since="1.0.0")
@NestMembers(value={1.class})
public interface CloudCache<K, V> {
    public void delete(@NonNull K var1);

    public void put(@NonNull K var1, @NonNull V var2);

    public @Nullable V getIfPresent(@NonNull K var1);

    default public @Nullable V popIfPresent(@NonNull K key) {
        V value = this.getIfPresent(key);
        if (value != null) {
            this.delete(key);
        }
        return value;
    }

    default public @NonNull Optional<V> get(@NonNull K key) {
        return Optional.ofNullable(this.getIfPresent(key));
    }

    default public <K1> @NonNull CloudCache<K1, V> keyExtractingView(final @NonNull Function<K1, K> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor");
        return new CloudCache<K1, V>(){

            @Override
            public void delete(@NonNull K1 key) {
                CloudCache.this.delete(keyExtractor.apply(key));
            }

            @Override
            public void put(@NonNull K1 key, @NonNull V value) {
                CloudCache.this.put(keyExtractor.apply(key), value);
            }

            @Override
            public @Nullable V getIfPresent(@NonNull K1 key) {
                return CloudCache.this.getIfPresent(keyExtractor.apply(key));
            }

            @Override
            public @Nullable V popIfPresent(@NonNull K1 key) {
                return CloudCache.this.popIfPresent(keyExtractor.apply(key));
            }

            @Override
            public @NonNull Optional<V> get(@NonNull K1 key) {
                return CloudCache.this.get(keyExtractor.apply(key));
            }
        };
    }
}

