/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.cooldown;

import java.util.Objects;
import java.util.function.Function;
import net.skinsrestorer.shadow.cloud.execution.postprocessor.CommandPostprocessor;
import net.skinsrestorer.shadow.cloud.key.CloudKey;
import net.skinsrestorer.shadow.cloud.processors.cooldown.Cooldown;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownConfiguration;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownPostprocessor;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownRepository;
import net.skinsrestorer.shadow.cloud.processors.cooldown.ImmutableCooldownConfiguration;
import net.skinsrestorer.shadow.geantyref.TypeToken;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@API(status=API.Status.STABLE, since="1.0.0")
@NestMembers(value={1.class})
public final class CooldownManager<C> {
    public static final CloudKey<Cooldown<?>> META_COOLDOWN_DURATION = CloudKey.of("cloud:cooldown_duration", new TypeToken<Cooldown<?>>(){});
    private final CooldownRepository<C> repository;
    private final CooldownConfiguration<C> configuration;

    public static <C> @NonNull CooldownManager<C> cooldownManager(@NonNull CooldownConfiguration<C> configuration) {
        return new CooldownManager<C>(Objects.requireNonNull(configuration, "configuration"));
    }

    public static <C> @NonNull CooldownManager<C> cooldownManager(@NonNull Function<ImmutableCooldownConfiguration.RepositoryBuildStage<C>, ImmutableCooldownConfiguration.BuildFinal<C>> configuration) {
        return CooldownManager.cooldownManager(configuration.apply(CooldownConfiguration.builder()).build());
    }

    private CooldownManager(@NonNull CooldownConfiguration<C> configuration) {
        this.repository = configuration.repository();
        this.configuration = configuration;
    }

    public @NonNull CooldownConfiguration<C> configuration() {
        return this.configuration;
    }

    public @NonNull CooldownRepository<C> repository() {
        return this.repository;
    }

    public @NonNull CommandPostprocessor<C> createPostprocessor() {
        return new CooldownPostprocessor(this);
    }
}

