/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.processors.cooldown;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import net.skinsrestorer.shadow.cloud.execution.postprocessor.CommandPostprocessingContext;
import net.skinsrestorer.shadow.cloud.execution.postprocessor.CommandPostprocessor;
import net.skinsrestorer.shadow.cloud.processors.cooldown.Cooldown;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownGroup;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownInstance;
import net.skinsrestorer.shadow.cloud.processors.cooldown.CooldownManager;
import net.skinsrestorer.shadow.cloud.processors.cooldown.ImmutableCooldownInstance;
import net.skinsrestorer.shadow.cloud.processors.cooldown.profile.CooldownProfile;
import net.skinsrestorer.shadow.cloud.services.type.ConsumerService;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;

@API(status=API.Status.INTERNAL, since="1.0.0")
final class CooldownPostprocessor<C>
implements CommandPostprocessor<C> {
    private final CooldownManager<C> cooldownManager;

    CooldownPostprocessor(@NonNull CooldownManager<C> cooldownManager) {
        this.cooldownManager = cooldownManager;
    }

    @Override
    public void accept(@NonNull CommandPostprocessingContext<C> context) {
        CooldownGroup group;
        Cooldown cooldown = context.command().commandMeta().getOrDefault(CooldownManager.META_COOLDOWN_DURATION, null);
        if (cooldown == null) {
            return;
        }
        if (this.cooldownManager.configuration().bypassCooldown().test(context.commandContext())) {
            return;
        }
        CooldownProfile profile = this.cooldownManager.repository().getProfile(context.commandContext().sender(), this.cooldownManager.configuration().profileFactory());
        CooldownInstance cooldownInstance = profile.getCooldown(group = cooldown.group() != null ? Objects.requireNonNull(cooldown.group(), "group") : this.cooldownManager.configuration().fallbackGroup().apply(context.command()));
        if (cooldownInstance != null) {
            Instant endTime = cooldownInstance.creationTime().plus(cooldownInstance.duration());
            Duration remainingTime = Duration.between(Instant.now(this.cooldownManager.configuration().clock()), endTime);
            this.cooldownManager.configuration().activeCooldownListeners().forEach(listener -> listener.cooldownActive(context.commandContext().sender(), context.command(), cooldownInstance, remainingTime));
            ConsumerService.interrupt();
            return;
        }
        ImmutableCooldownInstance instance = CooldownInstance.builder().profile(profile).group(group).duration(cooldown.duration().getDuration(context.commandContext())).creationTime(Instant.now(this.cooldownManager.configuration().clock())).build();
        profile.setCooldown(group, instance);
        this.cooldownManager.configuration().creationListeners().forEach(listener -> listener.cooldownCreated(context.commandContext().sender(), context.command(), instance));
    }
}

