/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.cloud.velocity;

import com.velocitypowered.api.command.RawCommand;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.cloud.component.CommandComponent;
import net.skinsrestorer.shadow.cloud.internal.CommandNode;
import net.skinsrestorer.shadow.cloud.permission.Permission;
import net.skinsrestorer.shadow.cloud.suggestion.Suggestion;
import net.skinsrestorer.shadow.cloud.suggestion.Suggestions;
import net.skinsrestorer.shadow.cloud.util.StringUtils;
import net.skinsrestorer.shadow.cloud.velocity.SRVelocityCommandManager;
import net.skinsrestorer.shadow.geantyref.GenericTypeReflector;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SRVelocityCommand<C>
implements RawCommand {
    private final SRVelocityCommandManager<C> manager;
    private final CommandComponent<C> command;

    SRVelocityCommand(@NonNull CommandComponent<C> command, @NonNull SRVelocityCommandManager<C> manager) {
        this.command = command;
        this.manager = manager;
    }

    public void execute(RawCommand.Invocation invocation) {
        String cmd = this.command.name();
        if (!((String)invocation.arguments()).isEmpty()) {
            cmd = SRVelocityCommand.jvmdowngrader$concat$execute$1(cmd, (String)invocation.arguments());
        }
        C sender = this.manager.senderMapper().map(invocation.source());
        this.manager.commandExecutor().executeCommand(sender, cmd);
    }

    public List<String> suggest(RawCommand.Invocation invocation) {
        String cmd = SRVelocityCommand.jvmdowngrader$concat$execute$1(this.command.name(), (String)invocation.arguments());
        Suggestions result = this.manager.suggestionFactory().suggestImmediately(this.manager.senderMapper().map(invocation.source()), cmd);
        return result.list().stream().map(Suggestion::suggestion).map(suggestion -> StringUtils.trimBeforeLastSpace(suggestion, result.commandInput())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean hasPermission(RawCommand.Invocation invocation) {
        CommandNode<C> node = this.namedNode();
        if (node == null) {
            return false;
        }
        Map accessMap = node.nodeMeta().getOrDefault(CommandNode.META_KEY_ACCESS, Collections.emptyMap());
        C cloudSender = this.manager.senderMapper().map(invocation.source());
        for (Map.Entry entry : accessMap.entrySet()) {
            if (!GenericTypeReflector.isSuperType((Type)entry.getKey(), cloudSender.getClass()) || !this.manager.testPermission(cloudSender, (Permission)entry.getValue()).allowed()) continue;
            return true;
        }
        return false;
    }

    private @Nullable CommandNode<C> namedNode() {
        return this.manager.commandTree().getNamedNode(this.command.name());
    }

    private static String jvmdowngrader$concat$execute$1(String string, String string2) {
        return string + " " + string2;
    }
}

