/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.injector.handlers.dependency;

import java.util.Collection;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.injector.context.ResolutionContext;
import net.skinsrestorer.shadow.injector.exceptions.InjectorException;
import net.skinsrestorer.shadow.injector.factory.SingletonStore;
import net.skinsrestorer.shadow.injector.handlers.Handler;
import net.skinsrestorer.shadow.injector.handlers.instantiation.Resolution;
import net.skinsrestorer.shadow.injector.handlers.instantiation.SimpleResolution;
import net.skinsrestorer.shadow.injector.utils.ReflectionUtils;

public class SingletonStoreDependencyHandler
implements Handler {
    @Override
    public Resolution<?> resolve(ResolutionContext context) {
        if (SingletonStore.class.equals(context.getIdentifier().getTypeAsClass())) {
            Class<?> genericType = ReflectionUtils.getGenericType(context.getIdentifier().getType());
            if (genericType == null) {
                throw new InjectorException("Singleton store fields must have concrete generic type. Cannot get generic type for field in '" + context.getIdentifier().getTypeAsClass() + "'");
            }
            return new SimpleResolution(new SingletonStoreImpl(genericType, context.getInjector()));
        }
        return null;
    }

    private static final class SingletonStoreImpl<P>
    implements SingletonStore<P> {
        private final Injector injector;
        private final Class<P> parentClass;

        SingletonStoreImpl(Class<P> parentClass, Injector injector) {
            this.parentClass = parentClass;
            this.injector = injector;
        }

        @Override
        public <C extends P> C getSingleton(Class<C> clazz) {
            if (this.parentClass.isAssignableFrom(clazz)) {
                return this.injector.getSingleton(clazz);
            }
            throw new InjectorException(clazz + " not child of " + this.parentClass);
        }

        @Override
        public Collection<P> retrieveAllOfType() {
            return this.retrieveAllOfType(this.parentClass);
        }

        @Override
        public <C extends P> Collection<C> retrieveAllOfType(Class<C> clazz) {
            if (this.parentClass.isAssignableFrom(clazz)) {
                return this.injector.retrieveAllOfType(clazz);
            }
            throw new InjectorException(clazz + " not child of " + this.parentClass);
        }
    }
}

