/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.connections;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.api.exception.DataRequestException;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.connections.http.HttpClient;
import net.skinsrestorer.shared.connections.http.HttpResponse;
import net.skinsrestorer.shared.connections.responses.RecommenationResponse;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;

public class RecommendationsService {
    private static final URI RECOMMENDATIONS_API = URI.create("https://cool-skins.skinsrestorer.net/list.json");
    private final SRLogger logger;
    private final SRPlugin plugin;
    private final HttpClient httpClient;

    public Optional<RecommenationResponse> getRecommendations() throws IOException, DataRequestException {
        HttpResponse response = this.httpClient.execute(RECOMMENDATIONS_API, null, HttpClient.HttpType.JSON, this.plugin.getUserAgent(), HttpClient.HttpMethod.GET, Collections.emptyMap(), 20000);
        if (response.statusCode() != 200) {
            this.logger.warning(J_L_String.formatted("Failed to get recommended skins. Response code: %d", response.statusCode()));
            return Optional.empty();
        }
        RecommenationResponse responseObject = response.getBodyAs(RecommenationResponse.class);
        return Optional.of(responseObject);
    }

    @Inject
    @Generated
    public RecommendationsService(SRLogger logger, SRPlugin plugin, HttpClient httpClient) {
        this.logger = logger;
        this.plugin = plugin;
        this.httpClient = httpClient;
    }
}

