/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.log;

import java.util.Map;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_L_MatchException;
import net.skinsrestorer.shared.log.SRChatColor;
import net.skinsrestorer.shared.utils.SRHelpers;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={1.class})
public class ANSIConverter {
    private static final Map<SRChatColor, String> replacements = SRHelpers.suppliedMap(SRChatColor.class, e -> {
        String string;
        switch (e) {
            default: {
                throw new J_L_MatchException(null, null);
            }
            case BLACK: {
                string = "\u001b[30;22m";
                break;
            }
            case DARK_BLUE: {
                string = "\u001b[34;22m";
                break;
            }
            case DARK_GREEN: {
                string = "\u001b[32;22m";
                break;
            }
            case DARK_AQUA: {
                string = "\u001b[36;22m";
                break;
            }
            case DARK_RED: {
                string = "\u001b[31;22m";
                break;
            }
            case DARK_PURPLE: {
                string = "\u001b[35;22m";
                break;
            }
            case GOLD: {
                string = "\u001b[33;22m";
                break;
            }
            case GRAY: {
                string = "\u001b[37;22m";
                break;
            }
            case DARK_GRAY: {
                string = "\u001b[30;1m";
                break;
            }
            case BLUE: {
                string = "\u001b[34;1m";
                break;
            }
            case GREEN: {
                string = "\u001b[32;1m";
                break;
            }
            case AQUA: {
                string = "\u001b[36;1m";
                break;
            }
            case RED: {
                string = "\u001b[31;1m";
                break;
            }
            case LIGHT_PURPLE: {
                string = "\u001b[35;1m";
                break;
            }
            case YELLOW: {
                string = "\u001b[33;1m";
                break;
            }
            case WHITE: {
                string = "\u001b[37;1m";
                break;
            }
            case MAGIC: {
                string = "\u001b[5m";
                break;
            }
            case BOLD: {
                string = "\u001b[21m";
                break;
            }
            case STRIKETHROUGH: {
                string = "\u001b[9m";
                break;
            }
            case UNDERLINE: {
                string = "\u001b[4m";
                break;
            }
            case ITALIC: {
                string = "\u001b[3m";
                break;
            }
            case RESET: {
                string = "\u001b[0;39m";
            }
        }
        return string;
    });
    private static final SRChatColor[] colors = SRChatColor.values();

    public static String convertToAnsi(String minecraftMessage) {
        String result = minecraftMessage;
        for (SRChatColor color : colors) {
            result = result.replaceAll(ANSIConverter.jvmdowngrader$concat$convertToAnsi$1(color.toString()), replacements.getOrDefault((Object)color, ""));
        }
        return result;
    }

    private static String jvmdowngrader$concat$convertToAnsi$1(String string) {
        return "(?i)" + string;
    }
}

