/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import lombok.Generated;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.exception.InitializeException;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.plugin.SRServerAdapter;
import net.skinsrestorer.shared.plugin.SRServerPlatformInit;
import net.skinsrestorer.shared.utils.SRHelpers;

public class SRServerPlugin {
    private final SRPlugin plugin;
    private final SRServerAdapter serverAdapter;
    private final SRLogger logger;
    private boolean proxyMode;

    public void checkProxyMode() {
        this.proxyMode = this.checkProxy();
        try {
            Path warning = this.plugin.getDataFolder().resolve("(README) Use proxy config for settings! (README).txt");
            if (this.proxyMode) {
                SRHelpers.createDirectoriesSafe(this.plugin.getDataFolder());
                SRHelpers.writeIfNeeded(warning, this.serverAdapter.getResouceAsString("proxy_warning.txt"));
            } else {
                Files.deleteIfExists(warning);
            }
        }
        catch (IOException e) {
            this.logger.severe("Failed to create proxy warning file", e);
        }
        if (this.proxyMode) {
            this.logger.info("-------------------------/Warning\\-------------------------");
            this.logger.info("This plugin is running in PROXY mode!");
            this.logger.info("You have to do all configuration at config file");
            this.logger.info("inside your BungeeCord/Velocity server.");
            this.logger.info("(<proxy>/plugins/SkinsRestorer/)");
            this.logger.info("-------------------------\\Warning/-------------------------");
        }
    }

    private boolean checkProxy() {
        Path proxyModeEnabled = this.plugin.getDataFolder().resolve("enableProxyMode.txt");
        Path proxyModeDisabled = this.plugin.getDataFolder().resolve("disableProxyMode.txt");
        if (Files.exists(proxyModeEnabled, new LinkOption[0])) {
            return true;
        }
        if (Files.exists(proxyModeDisabled, new LinkOption[0])) {
            return false;
        }
        return this.serverAdapter.determineProxy();
    }

    public void startupPlatform(SRServerPlatformInit init) throws InitializeException {
        init.initMetricsJoinListener();
        init.initPermissions();
        init.initGUIListener();
        init.initAdminInfoListener();
        if (this.proxyMode) {
            if (Files.exists(this.plugin.getDataFolder().resolve("enableSkinStorageAPI.txt"), new LinkOption[0])) {
                this.plugin.loadStorage();
                this.plugin.registerAPI();
                this.plugin.registerFloodgate();
            }
            init.initMessageChannel();
        } else {
            this.plugin.loadStorage();
            this.plugin.registerAPI();
            this.plugin.registerFloodgate();
            this.plugin.initCommands();
            init.initLoginProfileListener();
        }
        init.placeholderSetupHook();
    }

    @Inject
    @Generated
    public SRServerPlugin(SRPlugin plugin, SRServerAdapter serverAdapter, SRLogger logger) {
        this.plugin = plugin;
        this.serverAdapter = serverAdapter;
        this.logger = logger;
    }

    @Generated
    public boolean isProxyMode() {
        return this.proxyMode;
    }

    @Generated
    public void setProxyMode(boolean proxyMode) {
        this.proxyMode = proxyMode;
    }
}

