/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.subjects.messages;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.skinsrestorer.builddata.BuildData;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_N_F_Files;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shared.log.SRLogger;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.subjects.messages.LocaleManager;
import net.skinsrestorer.shared.subjects.messages.Message;
import net.skinsrestorer.shared.utils.LocaleParser;
import net.skinsrestorer.shared.utils.SRHelpers;
import net.skinsrestorer.shared.utils.TranslationReader;

public class MessageLoader {
    private final SRPlugin plugin;
    private final LocaleManager manager;
    private final SRPlatformAdapter adapter;
    private final SRLogger logger;

    public void loadMessages() throws IOException {
        this.loadDefaultMessages();
        this.loadCustomMessages();
        this.manager.verifyValid();
    }

    private void loadDefaultMessages() {
        for (String localeFile : BuildData.LOCALES) {
            String resourcePath = J_L_String.formatted("locales/%s", localeFile);
            Locale locale = this.getTranslationLocale(localeFile);
            int count = 0;
            for (Map.Entry<String, String> entry : TranslationReader.readJsonTranslation(this.adapter.getResouceAsString(resourcePath)).entrySet()) {
                Optional<Message> message = Message.fromKey(entry.getKey());
                if (J_U_Optional.isEmpty(message) && locale != LocaleManager.BASE_LOCALE) continue;
                this.manager.addMessage(message.orElseThrow(() -> new IllegalArgumentException(J_L_String.formatted("No message enum found for key %s", entry.getKey()))), locale, entry.getValue());
                ++count;
            }
            this.logger.debug(J_L_String.formatted("Loaded %d default message strings for locale %s", count, locale));
        }
    }

    private void loadCustomMessages() throws IOException {
        Path localesFolder = this.plugin.getDataFolder().resolve("locales");
        Path repositoryFolder = localesFolder.resolve("repository");
        Path customFolder = localesFolder.resolve("custom");
        SRHelpers.createDirectoriesSafe(repositoryFolder);
        SRHelpers.createDirectoriesSafe(customFolder);
        for (String localeFile : BuildData.LOCALES) {
            String resourcePath = J_L_String.formatted("locales/%s", localeFile);
            Path filePath = repositoryFolder.resolve(localeFile);
            SRHelpers.writeIfNeeded(filePath, this.adapter.getResouceAsString(resourcePath));
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(customFolder);){
            boolean found = false;
            for (Path path : stream) {
                String fileName;
                Path localeFile;
                if (Files.isDirectory(path, new LinkOption[0]) || (localeFile = path.getFileName()) == null || !this.isJson(fileName = localeFile.toString())) continue;
                if (!found) {
                    this.logger.info("Found custom translations, loading...");
                    found = true;
                }
                Locale locale = this.getTranslationLocale(fileName);
                int count = 0;
                for (Map.Entry<String, String> entry : TranslationReader.readJsonTranslation(J_N_F_Files.readString(path)).entrySet()) {
                    Optional<Message> message = Message.fromKey(entry.getKey());
                    if (J_U_Optional.isEmpty(message)) {
                        this.logger.warning(J_L_String.formatted("Skipping unknown message key %s", entry.getKey()));
                        continue;
                    }
                    this.manager.addMessage(message.get(), locale, entry.getValue());
                    ++count;
                }
                this.logger.debug(J_L_String.formatted("Loaded %d custom message strings for locale %s", count, locale));
            }
        }
    }

    private boolean isJson(String fileName) {
        return fileName.endsWith(".json");
    }

    private Locale getTranslationLocale(String fileName) {
        return fileName.startsWith("locale_") ? LocaleParser.parseLocaleStrict(this.stripFileFormat(fileName)) : Locale.ENGLISH;
    }

    private String stripFileFormat(String fileName) {
        return fileName.replace("locale_", "").replace(".json", "");
    }

    @Inject
    @Generated
    public MessageLoader(SRPlugin plugin, LocaleManager manager, SRPlatformAdapter adapter, SRLogger logger) {
        this.plugin = plugin;
        this.manager = manager;
        this.adapter = adapter;
        this.logger = logger;
    }
}

