/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.update;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.skinsrestorer.shadow.injector.Injector;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shared.plugin.SRPlatformAdapter;
import net.skinsrestorer.shared.plugin.SRPlugin;
import net.skinsrestorer.shared.update.DownloaderClassProvider;
import net.skinsrestorer.shared.update.UpdateCause;
import net.skinsrestorer.shared.update.UpdateCheckExecutor;
import net.skinsrestorer.shared.update.UpdateCheckerGitHub;
import net.skinsrestorer.shared.update.UpdateDownloader;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={InitCause.class})
public class UpdateCheckInit {
    private final SRPlugin plugin;
    private final SRPlatformAdapter adapter;
    private final UpdateCheckerGitHub updateChecker;
    private final UpdateCheckExecutor updateCheckExecutor;
    private final Injector injector;

    public Optional<UpdateDownloader> getDownloader() {
        boolean downloaderDisabled = Files.exists(this.plugin.getDataFolder().resolve("noupdate.txt"), new LinkOption[0]);
        DownloaderClassProvider downloaderClassProvider = this.injector.getIfAvailable(DownloaderClassProvider.class);
        return downloaderClassProvider == null || downloaderDisabled ? Optional.empty() : Optional.of((UpdateDownloader)this.injector.getSingleton((Class)downloaderClassProvider.get()));
    }

    public void run(InitCause cause) {
        UpdateDownloader downloader = this.getDownloader().orElse(null);
        this.updateCheckExecutor.checkUpdate(cause.toUpdateCause(), this.updateChecker, downloader, true);
        int delayInt = 60 + ThreadLocalRandom.current().nextInt(181);
        this.adapter.runRepeatAsync(() -> this.updateCheckExecutor.checkUpdate(UpdateCause.SCHEDULED, this.updateChecker, downloader, false), delayInt, delayInt, TimeUnit.MINUTES);
    }

    @Inject
    @Generated
    public UpdateCheckInit(SRPlugin plugin, SRPlatformAdapter adapter, UpdateCheckerGitHub updateChecker, UpdateCheckExecutor updateCheckExecutor, Injector injector) {
        this.plugin = plugin;
        this.adapter = adapter;
        this.updateChecker = updateChecker;
        this.updateCheckExecutor = updateCheckExecutor;
        this.injector = injector;
    }

    @NestHost(value=UpdateCheckInit.class)
    public static enum InitCause {
        STARTUP,
        ERROR;


        public UpdateCause toUpdateCause() {
            return this == STARTUP ? UpdateCause.STARTUP : UpdateCause.ERROR;
        }
    }
}

