/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j15.stub.java_base.J_L_String;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@NestMembers(value={ParameterPair.class})
public class ReflectionUtil {
    private static final Map<Class<?>, Class<?>> wrap2primitiveMap = new HashMap();

    private ReflectionUtil() {
    }

    public static boolean classExists(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean classExists(String ... classNames) {
        for (String className : classNames) {
            if (!ReflectionUtil.classExists(className)) continue;
            return true;
        }
        return false;
    }

    public static Enum<?> getEnum(Class<?> clazz, String constant) throws ReflectiveOperationException {
        Enum[] enumConstants;
        for (Enum e : enumConstants = (Enum[])clazz.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(constant)) continue;
            return e;
        }
        throw new ReflectiveOperationException(J_L_String.formatted("Enum constant not found %s", constant));
    }

    public static Enum<?> getEnum(Class<?> clazz, int ordinal) throws ReflectiveOperationException {
        try {
            return (Enum)clazz.getEnumConstants()[ordinal];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ReflectiveOperationException(J_L_String.formatted("Enum constant not found %s", ordinal));
        }
    }

    public static Enum<?> getEnum(Class<?> clazz, String enumName, String constant) throws ReflectiveOperationException {
        return ReflectionUtil.getEnum(ReflectionUtil.getSubClass(clazz, enumName), constant);
    }

    private static Class<?> getSubClass(Class<?> clazz, String className) throws ReflectiveOperationException {
        for (Class<?> subClass : clazz.getDeclaredClasses()) {
            if (!subClass.getSimpleName().equals(className)) continue;
            return subClass;
        }
        for (Class<?> subClass : clazz.getClasses()) {
            if (!subClass.getSimpleName().equals(className)) continue;
            return subClass;
        }
        throw new ClassNotFoundException(J_L_String.formatted("Sub class %s of %s not found!", className, clazz.getSimpleName()));
    }

    public static Field getField(Class<?> clazz, String fieldName) throws ReflectiveOperationException {
        Field f;
        try {
            f = clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            f = clazz.getField(fieldName);
        }
        f.setAccessible(true);
        return f;
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... args) throws ReflectiveOperationException {
        Method m;
        try {
            m = clazz.getDeclaredMethod(methodName, args);
        }
        catch (Exception e) {
            m = clazz.getMethod(methodName, args);
        }
        m.setAccessible(true);
        return m;
    }

    public static <T> T getObject(Object obj, String fieldName) throws ReflectiveOperationException {
        return (T)ReflectionUtil.getField(obj.getClass(), fieldName).get(obj);
    }

    public static Object getFieldByType(Object obj, String typeName) throws ReflectiveOperationException {
        return ReflectionUtil.getFieldByType(obj, obj.getClass(), typeName);
    }

    private static Object getFieldByType(Object obj, Class<?> superClass, String typeName) throws ReflectiveOperationException {
        return J_U_List.getFirst(ReflectionUtil.getFieldByTypeList(obj, superClass, typeName));
    }

    public static List<Object> getFieldByTypeList(Object obj, String typeName) throws ReflectiveOperationException {
        return ReflectionUtil.getFieldByTypeList(obj, obj.getClass(), typeName);
    }

    private static List<Object> getFieldByTypeList(Object obj, Class<?> superClass, String typeName) throws ReflectiveOperationException {
        ArrayList<Object> fields = new ArrayList<Object>();
        for (Field f : superClass.getDeclaredFields()) {
            if (!f.getType().getSimpleName().equalsIgnoreCase(typeName)) continue;
            f.setAccessible(true);
            fields.add(f.get(obj));
        }
        if (superClass.getSuperclass() != null) {
            fields.addAll(ReflectionUtil.getFieldByTypeList(obj, superClass.getSuperclass(), typeName));
        }
        if (fields.isEmpty() && obj.getClass() == superClass) {
            throw new ReflectiveOperationException(J_L_String.formatted("Could not find field of type %s in %s", typeName, obj.getClass().getSimpleName()));
        }
        return fields;
    }

    public static Object invokeConstructor(Class<?> clazz, Class<?>[] args, Object ... initArgs) throws ReflectiveOperationException {
        return ReflectionUtil.getConstructor(clazz, args).newInstance(initArgs);
    }

    public static Object invokeConstructor(Class<?> clazz, Object ... initArgs) throws ReflectiveOperationException {
        return ReflectionUtil.getConstructorByArgs(clazz, initArgs).newInstance(initArgs);
    }

    private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... args) throws ReflectiveOperationException {
        Constructor<?> c = clazz.getConstructor(args);
        c.setAccessible(true);
        return c;
    }

    private static Constructor<?> getConstructorByArgs(Class<?> clazz, Object ... args) throws ReflectiveOperationException {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != args.length) continue;
            int i = 0;
            for (Class<?> parameter : constructor.getParameterTypes()) {
                if (!ReflectionUtil.isAssignable(parameter, args[i])) break;
                ++i;
            }
            if (i != args.length) continue;
            return constructor;
        }
        String argsString = Arrays.stream(args).map(s -> s == null ? "null" : s.getClass().getSimpleName()).collect(Collectors.joining(", "));
        throw new ReflectiveOperationException(J_L_String.formatted("Could not find constructor with args %s in %s", argsString, clazz.getSimpleName()));
    }

    private static boolean isAssignable(Class<?> clazz, Object obj) {
        return (clazz = ReflectionUtil.convertToPrimitive(clazz)).isInstance(obj) || clazz == ReflectionUtil.convertToPrimitive(obj.getClass());
    }

    private static Class<?> convertToPrimitive(Class<?> clazz) {
        return wrap2primitiveMap.getOrDefault(clazz, clazz);
    }

    public static Object invokeObjectMethod(@NotNull Object obj, String method, ParameterPair<?> ... parameters) throws ReflectiveOperationException {
        return ReflectionUtil.getMethod(obj.getClass(), method, ParameterPair.jvmdowngrader$nest$net_skinsrestorer_shared_utils_ReflectionUtil$ParameterPair$classesFromArgs(parameters)).invoke(obj, ParameterPair.jvmdowngrader$nest$net_skinsrestorer_shared_utils_ReflectionUtil$ParameterPair$valuesFromArgs(parameters));
    }

    public static Object invokeStaticMethod(@NotNull Class<?> clazz, String method, ParameterPair<?> ... parameters) throws ReflectiveOperationException {
        return ReflectionUtil.getMethod(clazz, method, ParameterPair.jvmdowngrader$nest$net_skinsrestorer_shared_utils_ReflectionUtil$ParameterPair$classesFromArgs(parameters)).invoke(null, ParameterPair.jvmdowngrader$nest$net_skinsrestorer_shared_utils_ReflectionUtil$ParameterPair$valuesFromArgs(parameters));
    }

    static {
        wrap2primitiveMap.put(Integer.class, Integer.TYPE);
        wrap2primitiveMap.put(Long.class, Long.TYPE);
        wrap2primitiveMap.put(Double.class, Double.TYPE);
        wrap2primitiveMap.put(Float.class, Float.TYPE);
        wrap2primitiveMap.put(Boolean.class, Boolean.TYPE);
        wrap2primitiveMap.put(Character.class, Character.TYPE);
        wrap2primitiveMap.put(Byte.class, Byte.TYPE);
        wrap2primitiveMap.put(Short.class, Short.TYPE);
    }

    @RecordComponents(value={@RecordComponents.Value(name="clazz", type=Class.class), @RecordComponents.Value(name="value", type=Object.class)})
    @NestHost(value=ReflectionUtil.class)
    public static final class ParameterPair<P>
    extends J_L_Record {
        private final Class<?> clazz;
        private final P value;

        public ParameterPair(P value) {
            this(value.getClass(), value);
        }

        public ParameterPair(Class<?> clazz, P value) {
            this.clazz = clazz;
            this.value = value;
        }

        private static Class<?>[] classesFromArgs(ParameterPair<?> ... args) {
            return (Class[])Arrays.stream(args).map(ParameterPair::clazz).toArray(Class[]::new);
        }

        private static Object[] valuesFromArgs(ParameterPair<?> ... args) {
            return Arrays.stream(args).map(ParameterPair::value).toArray(Object[]::new);
        }

        @Override
        public final String toString() {
            return ParameterPair.jvmdowngrader$toString$toString(this);
        }

        @Override
        public final int hashCode() {
            return ParameterPair.jvmdowngrader$hashCode$hashCode(this);
        }

        @Override
        public final boolean equals(Object o) {
            return ParameterPair.jvmdowngrader$equals$equals(this, o);
        }

        public Class<?> clazz() {
            return this.clazz;
        }

        public P value() {
            return this.value;
        }

        private static String jvmdowngrader$toString$toString(ParameterPair parameterPair) {
            ParameterPair parameterPair2 = parameterPair;
            return "ReflectionUtil$ParameterPair[" + "clazz=" + parameterPair.clazz + ", " + "value=" + parameterPair.value + "]";
        }

        private static int jvmdowngrader$hashCode$hashCode(ParameterPair parameterPair) {
            Object[] objectArray = new Object[]{parameterPair.clazz, parameterPair.value};
            return Arrays.hashCode(objectArray);
        }

        private static boolean jvmdowngrader$equals$equals(ParameterPair parameterPair, Object object) {
            if (parameterPair == object) {
                return true;
            }
            if (object != null && object instanceof ParameterPair) {
                ParameterPair parameterPair2 = (ParameterPair)object;
                if (Objects.equals(parameterPair.clazz, parameterPair2.clazz) && Objects.equals(parameterPair.value, parameterPair2.value)) {
                    return true;
                }
            }
            return false;
        }

        public static Class[] jvmdowngrader$nest$net_skinsrestorer_shared_utils_ReflectionUtil$ParameterPair$classesFromArgs(ParameterPair[] parameterPairArray) {
            return ParameterPair.classesFromArgs(parameterPairArray);
        }

        public static Object[] jvmdowngrader$nest$net_skinsrestorer_shared_utils_ReflectionUtil$ParameterPair$valuesFromArgs(ParameterPair[] parameterPairArray) {
            return ParameterPair.valuesFromArgs(parameterPairArray);
        }
    }
}

