/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity;

import com.google.inject.Injector;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.skinsrestorer.api.property.SkinProperty;
import net.skinsrestorer.shadow.bstats.velocity.Metrics;
import net.skinsrestorer.shadow.cloud.CommandManager;
import net.skinsrestorer.shadow.cloud.SenderMapper;
import net.skinsrestorer.shadow.cloud.execution.ExecutionCoordinator;
import net.skinsrestorer.shadow.cloud.velocity.SRVelocityCommandManager;
import net.skinsrestorer.shadow.javax.inject.Inject;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j10.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j16.stub.java_base.J_L_Record;
import net.skinsrestorer.shared.info.Platform;
import net.skinsrestorer.shared.info.PluginInfo;
import net.skinsrestorer.shared.plugin.SRProxyAdapter;
import net.skinsrestorer.shared.subjects.SRCommandSender;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.velocity.SRVelocityBootstrap;
import net.skinsrestorer.velocity.SkinApplierVelocity;
import net.skinsrestorer.velocity.listener.ForceAliveListener;
import net.skinsrestorer.velocity.wrapper.WrapperVelocity;
import xyz.wagyourtail.jvmdg.j16.RecordComponents;

@RecordComponents(value={@RecordComponents.Value(name="injector", type=net.skinsrestorer.shadow.injector.Injector.class), @RecordComponents.Value(name="pluginInstance", type=SRVelocityBootstrap.class), @RecordComponents.Value(name="proxy", type=ProxyServer.class)})
public final class SRVelocityAdapter
extends J_L_Record
implements SRProxyAdapter {
    private final net.skinsrestorer.shadow.injector.Injector injector;
    private final SRVelocityBootstrap pluginInstance;
    private final ProxyServer proxy;

    @Inject
    public SRVelocityAdapter(net.skinsrestorer.shadow.injector.Injector injector, SRVelocityBootstrap pluginInstance, ProxyServer proxy) {
        this.injector = injector;
        this.pluginInstance = pluginInstance;
        this.proxy = proxy;
    }

    @Override
    public Object createMetricsInstance() {
        Metrics.Factory metricsFactory = (Metrics.Factory)this.injector.getSingleton(Injector.class).getInstance(Metrics.Factory.class);
        return metricsFactory.make(this.pluginInstance, 10606);
    }

    @Override
    public InputStream getResource(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    @Override
    public CommandManager<SRCommandSender> createCommandManager() {
        WrapperVelocity wrapper = this.injector.getSingleton(WrapperVelocity.class);
        return new SRVelocityCommandManager<SRCommandSender>((PluginContainer)J_U_Optional.orElseThrow(this.proxy.getPluginManager().fromInstance((Object)this.pluginInstance)), this.proxy, ExecutionCoordinator.asyncCoordinator(), SenderMapper.create(wrapper::commandSender, wrapper::unwrap));
    }

    @Override
    public void runAsync(Runnable runnable) {
        this.proxy.getScheduler().buildTask((Object)this.pluginInstance, runnable).schedule();
    }

    @Override
    public void runRepeatAsync(Runnable runnable, int delay, int interval, TimeUnit timeUnit) {
        this.proxy.getScheduler().buildTask((Object)this.pluginInstance, runnable).delay((long)delay, timeUnit).repeat((long)interval, timeUnit).schedule();
    }

    @Override
    public void extendLifeTime(Object plugin, Object object) {
        this.proxy.getEventManager().register(plugin, ProxyShutdownEvent.class, PostOrder.LAST, (EventHandler)new ForceAliveListener(object));
    }

    @Override
    public boolean supportsDefaultPermissions() {
        return true;
    }

    @Override
    public String getPlatformVersion() {
        return this.proxy.getVersion().getVersion();
    }

    @Override
    public String getPlatformName() {
        return this.proxy.getVersion().getName();
    }

    @Override
    public String getPlatformVendor() {
        return this.proxy.getVersion().getVendor();
    }

    @Override
    public Platform getPlatform() {
        return Platform.VELOCITY;
    }

    @Override
    public List<PluginInfo> getPlugins() {
        return this.proxy.getPluginManager().getPlugins().stream().map(p -> new PluginInfo(p.getInstance().isPresent(), p.getDescription().getName().orElseGet(() -> p.getDescription().getId()), p.getDescription().getVersion().orElse("Unknown"), p.getInstance().map(i -> i.getClass().getCanonicalName()).orElse("N/A"), p.getDescription().getAuthors().toArray(new String[0]))).collect(Collectors.toList());
    }

    @Override
    public Optional<SkinProperty> getSkinProperty(SRPlayer player) {
        return this.injector.getSingleton(SkinApplierVelocity.class).getSkinProperty(player.getAs(Player.class));
    }

    @Override
    public Collection<SRPlayer> getOnlinePlayers(SRCommandSender sender) {
        return this.proxy.getAllPlayers().stream().map(this.injector.getSingleton(WrapperVelocity.class)::player).collect(Collectors.toList());
    }

    @Override
    public Optional<SRPlayer> getPlayer(SRCommandSender sender, UUID uniqueId) {
        return this.proxy.getPlayer(uniqueId).map(this.injector.getSingleton(WrapperVelocity.class)::player);
    }

    @Override
    public final String toString() {
        return SRVelocityAdapter.jvmdowngrader$toString$toString(this);
    }

    @Override
    public final int hashCode() {
        return SRVelocityAdapter.jvmdowngrader$hashCode$hashCode(this);
    }

    @Override
    public final boolean equals(Object o) {
        return SRVelocityAdapter.jvmdowngrader$equals$equals(this, o);
    }

    public net.skinsrestorer.shadow.injector.Injector injector() {
        return this.injector;
    }

    public SRVelocityBootstrap pluginInstance() {
        return this.pluginInstance;
    }

    public ProxyServer proxy() {
        return this.proxy;
    }

    private static String jvmdowngrader$toString$toString(SRVelocityAdapter sRVelocityAdapter) {
        SRVelocityAdapter sRVelocityAdapter2 = sRVelocityAdapter;
        return "SRVelocityAdapter[" + "injector=" + sRVelocityAdapter.injector + ", " + "pluginInstance=" + sRVelocityAdapter.pluginInstance + ", " + "proxy=" + sRVelocityAdapter.proxy + "]";
    }

    private static int jvmdowngrader$hashCode$hashCode(SRVelocityAdapter sRVelocityAdapter) {
        Object[] objectArray = new Object[]{sRVelocityAdapter.injector, sRVelocityAdapter.pluginInstance, sRVelocityAdapter.proxy};
        return Arrays.hashCode(objectArray);
    }

    private static boolean jvmdowngrader$equals$equals(SRVelocityAdapter sRVelocityAdapter, Object object) {
        if (sRVelocityAdapter == object) {
            return true;
        }
        if (object != null && object instanceof SRVelocityAdapter) {
            SRVelocityAdapter sRVelocityAdapter2 = (SRVelocityAdapter)object;
            if (Objects.equals(sRVelocityAdapter.injector, sRVelocityAdapter2.injector) && Objects.equals(sRVelocityAdapter.pluginInstance, sRVelocityAdapter2.pluginInstance) && Objects.equals(sRVelocityAdapter.proxy, sRVelocityAdapter2.proxy)) {
                return true;
            }
        }
        return false;
    }
}

