/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.velocity.wrapper;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j11.stub.java_base.J_U_Optional;
import net.skinsrestorer.shadow.jvmdowngrader.xyz.wagyourtail.jvmdg.j9.stub.java_base.J_U_Objects;
import net.skinsrestorer.shared.config.MessageConfig;
import net.skinsrestorer.shared.subjects.SRPlayer;
import net.skinsrestorer.shared.subjects.SRProxyPlayer;
import net.skinsrestorer.velocity.wrapper.WrapperCommandSender;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;

@NestMembers(value={WrapperPlayerBuilderImpl.class, WrapperPlayerBuilder.class})
public class WrapperPlayer
extends WrapperCommandSender
implements SRProxyPlayer {
    private static final ChannelIdentifier MESSAGE_CHANNEL = MinecraftChannelIdentifier.from((String)"sr:messagechannel");
    @NonNull
    private final Player player;

    @Override
    public Locale getLocale() {
        if (!this.settings.getProperty(MessageConfig.PER_ISSUER_LOCALE).booleanValue()) {
            return this.settings.getProperty(MessageConfig.LOCALE);
        }
        return J_U_Objects.requireNonNullElseGet(this.player.getEffectiveLocale(), () -> this.settings.getProperty(MessageConfig.LOCALE));
    }

    @Override
    public String getName() {
        return this.player.getUsername();
    }

    @Override
    public Optional<String> getCurrentServer() {
        return this.player.getCurrentServer().map(server -> server.getServerInfo().getName());
    }

    @Override
    public void sendToMessageChannel(byte[] data) {
        if (!this.player.isActive()) {
            return;
        }
        Optional serverConnection = this.player.getCurrentServer();
        if (J_U_Optional.isEmpty(serverConnection)) {
            return;
        }
        ((ServerConnection)serverConnection.get()).sendPluginMessage(MESSAGE_CHANNEL, data);
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public boolean canSee(SRPlayer player) {
        return true;
    }

    @Generated
    protected WrapperPlayer(WrapperPlayerBuilder<?, ?> b) {
        super((WrapperCommandSender.WrapperCommandSenderBuilder<?, ?>)b);
        this.player = b.jvmdowngrader$nest$net_skinsrestorer_velocity_wrapper_WrapperPlayer$WrapperPlayerBuilder$get$player();
        if (this.player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    @NotNull
    @Generated
    public static WrapperPlayerBuilder<?, ?> builder() {
        return new WrapperPlayerBuilderImpl();
    }

    @NestHost(value=WrapperPlayer.class)
    @Generated
    public static abstract class WrapperPlayerBuilder<C extends WrapperPlayer, B extends WrapperPlayerBuilder<C, B>>
    extends WrapperCommandSender.WrapperCommandSenderBuilder<C, B> {
        @Generated
        private Player player;

        @NotNull
        @Generated
        public B player(@NonNull Player player) {
            if (player == null) {
                throw new NullPointerException("player is marked non-null but is null");
            }
            this.player = player;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @NotNull
        @Generated
        public String toString() {
            return WrapperPlayerBuilder.jvmdowngrader$concat$toString$1(super.toString(), String.valueOf(this.player));
        }

        public Player jvmdowngrader$nest$net_skinsrestorer_velocity_wrapper_WrapperPlayer$WrapperPlayerBuilder$get$player() {
            return this.player;
        }

        public void jvmdowngrader$nest$net_skinsrestorer_velocity_wrapper_WrapperPlayer$WrapperPlayerBuilder$set$player(Player player) {
            this.player = player;
        }

        private static String jvmdowngrader$concat$toString$1(String string, String string2) {
            return "WrapperPlayer.WrapperPlayerBuilder(super=" + string + ", player=" + string2 + ")";
        }
    }

    @NestHost(value=WrapperPlayer.class)
    @Generated
    private static final class WrapperPlayerBuilderImpl
    extends WrapperPlayerBuilder<WrapperPlayer, WrapperPlayerBuilderImpl> {
        @Generated
        WrapperPlayerBuilderImpl() {
        }

        @Override
        @Generated
        protected WrapperPlayerBuilderImpl self() {
            return this;
        }

        @Override
        @NotNull
        @Generated
        public WrapperPlayer build() {
            return new WrapperPlayer(this);
        }
    }
}

