/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.art.api.IdentifierFixerConfig;
import net.neoforged.art.api.Renamer;
import net.neoforged.art.api.SignatureStripperConfig;
import net.neoforged.art.api.SourceFixerConfig;
import net.neoforged.art.api.Transformer;
import net.neoforged.srgutils.IMappingFile;

public class Main {
    public static void main(String[] args) throws IOException {
        OptionSet options;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec inputO = parser.accepts("input", "Input jar file").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output", "Output jar file, if unspecifed, overwrites input").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec mapO = parser.acceptsAll(Arrays.asList("map", "names"), "Mapping file to apply").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec logO = parser.accepts("log", "File to log data to, optional, defaults to System.out").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec libO = parser.acceptsAll(Arrays.asList("lib", "e"), "Additional library to use for inheritance").withRequiredArg().ofType(File.class);
        OptionSpecBuilder fixAnnO = parser.accepts("ann-fix", "Fixes misaligned parameter annotations caused by Proguard");
        OptionSpecBuilder unfinalParams0 = parser.accepts("unfinal-params", "Remove final flag from parameters");
        OptionSpecBuilder fixRecordsO = parser.accepts("record-fix", "Fixes record components and attributes stripped by Proguard.");
        ArgumentAcceptingOptionSpec fixIdsO = parser.accepts("ids-fix", "Fixes local variables that are not valid java identifiers.").withOptionalArg().withValuesConvertedBy(new EnumConverter(IdentifierFixerConfig.class)).defaultsTo((Object)IdentifierFixerConfig.ALL, (Object[])new IdentifierFixerConfig[0]);
        ArgumentAcceptingOptionSpec fixSrcO = parser.accepts("src-fix", "Fixes the 'SourceFile' attribute of classes.").withOptionalArg().withValuesConvertedBy(new EnumConverter(SourceFixerConfig.class)).defaultsTo((Object)SourceFixerConfig.JAVA, (Object[])new SourceFixerConfig[0]);
        ArgumentAcceptingOptionSpec stripSigsO = parser.accepts("strip-sigs", "Strip invalid codesigning signatures from the Jar manifest").withOptionalArg().withValuesConvertedBy(new EnumConverter(SignatureStripperConfig.class)).defaultsTo((Object)SignatureStripperConfig.ALL, (Object[])new SignatureStripperConfig[0]);
        ArgumentAcceptingOptionSpec threadsO = parser.accepts("threads", "Number of threads to use, defaults to processor count.").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Runtime.getRuntime().availableProcessors(), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec ffLinesO = parser.accepts("ff-line-numbers", "Applies line number corrections from Fernflower.").withRequiredArg().ofType(File.class);
        OptionSpecBuilder reverseO = parser.accepts("reverse", "Reverse provided mapping file before applying");
        OptionSpecBuilder disableAbstractParam = parser.accepts("disable-abstract-param", "Disables collection of names of parameters of abstract methods for FernFlower");
        try {
            options = parser.parse(Main.expandArgs(args));
        }
        catch (OptionException ex) {
            System.err.println("Error: " + ex.getMessage());
            System.err.println();
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
            return;
        }
        Consumer<String> log = ln -> {
            if (!ln.isEmpty()) {
                System.out.println((String)ln);
            }
        };
        if (options.has((OptionSpec)logO)) {
            PrintStream out = System.out;
            PrintStream file = new PrintStream(new FileOutputStream((File)options.valueOf((OptionSpec)logO)));
            log = ln -> {
                if (!ln.isEmpty()) {
                    out.println((String)ln);
                    file.println((String)ln);
                }
            };
        }
        log.accept("Forge Auto Renaming Tool v" + Main.getVersion());
        Renamer.Builder builder = Renamer.builder();
        builder.withJvmClasspath();
        builder.logger(log);
        if (options.has((OptionSpec)libO)) {
            for (File lib : options.valuesOf((OptionSpec)libO)) {
                log.accept("lib: " + lib.getAbsolutePath());
                builder.lib(lib);
            }
        }
        log.accept("log: " + (options.has((OptionSpec)logO) ? ((File)options.valueOf((OptionSpec)logO)).getAbsolutePath() : "null"));
        File inputF = (File)options.valueOf((OptionSpec)inputO);
        log.accept("input: " + inputF.getAbsolutePath());
        File outputF = options.has((OptionSpec)outputO) ? (File)options.valueOf((OptionSpec)outputO) : inputF;
        log.accept("output: " + outputF.getAbsolutePath());
        log.accept("threads: " + options.valueOf((OptionSpec)threadsO));
        builder.threads((Integer)options.valueOf((OptionSpec)threadsO));
        if (options.has((OptionSpec)mapO)) {
            File mapF = (File)options.valueOf((OptionSpec)mapO);
            log.accept("Names: " + mapF.getAbsolutePath() + "(reversed: " + options.has((OptionSpec)reverseO) + ")");
            IMappingFile mappings = IMappingFile.load((File)mapF);
            if (options.has((OptionSpec)reverseO)) {
                mappings = mappings.reverse();
            }
            builder.add(Transformer.renamerFactory(mappings, !options.has((OptionSpec)disableAbstractParam)));
        } else {
            log.accept("Names: null");
        }
        if (options.has((OptionSpec)fixAnnO)) {
            log.accept("Fix Annotations: true");
            builder.add(Transformer.parameterAnnotationFixerFactory());
        } else {
            log.accept("Fix Annotations: false");
        }
        if (options.has((OptionSpec)unfinalParams0)) {
            log.accept("Unfinal Parameters: true");
            builder.add(Transformer.parameterFinalFlagRemoverFactory());
        } else {
            log.accept("Unfinal Parameters: false");
        }
        if (options.has((OptionSpec)fixRecordsO)) {
            log.accept("Fix Records: true");
            builder.add(Transformer.recordFixerFactory());
        } else {
            log.accept("Fix Records: false");
        }
        if (options.has((OptionSpec)fixIdsO)) {
            log.accept("Fix Identifiers: " + options.valueOf((OptionSpec)fixIdsO));
            builder.add(Transformer.identifierFixerFactory((IdentifierFixerConfig)((Object)options.valueOf((OptionSpec)fixIdsO))));
        } else {
            log.accept("Fix Identifiers: false");
        }
        if (options.has((OptionSpec)fixSrcO)) {
            log.accept("Fix SourceFile: " + options.valueOf((OptionSpec)fixSrcO));
            builder.add(Transformer.sourceFixerFactory((SourceFixerConfig)((Object)options.valueOf((OptionSpec)fixSrcO))));
        } else {
            log.accept("Fix SourceFile: false");
        }
        if (options.has((OptionSpec)ffLinesO)) {
            File lines = (File)options.valueOf((OptionSpec)ffLinesO);
            log.accept("Fix Line Numbers: " + lines.getAbsolutePath());
            builder.add(Transformer.fernFlowerLineFixerFactory(lines));
        } else {
            log.accept("Fix Line Numbers: false");
        }
        if (options.has((OptionSpec)stripSigsO)) {
            SignatureStripperConfig config = (SignatureStripperConfig)((Object)options.valueOf((OptionSpec)stripSigsO));
            log.accept("Strip codesigning signatures: " + (Object)((Object)config));
            builder.add(Transformer.signatureStripperFactory(config));
        } else {
            log.accept("Strip codesigning signatures: false");
        }
        try (Renamer renamer = builder.build();){
            renamer.run(inputF, outputF);
        }
    }

    private static String[] expandArgs(String[] args) throws IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (int x = 0; x < args.length; ++x) {
            Throwable throwable;
            Stream<String> lines;
            if (args[x].equals("--cfg")) {
                if (x + 1 == args.length) {
                    throw new IllegalArgumentException("No value specified for '--cfg'");
                }
                lines = Files.lines(Paths.get(args[++x], new String[0]));
                throwable = null;
                try {
                    lines.forEach(ret::add);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lines != null) {
                        if (throwable != null) {
                            try {
                                lines.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            lines.close();
                        }
                    }
                }
            }
            if (args[x].startsWith("--cfg=")) {
                lines = Files.lines(Paths.get(args[x].substring(6), new String[0]));
                throwable = null;
                try {
                    lines.forEach(ret::add);
                    continue;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (lines != null) {
                        if (throwable != null) {
                            try {
                                lines.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            lines.close();
                        }
                    }
                }
            }
            ret.add(args[x]);
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static String getVersion() {
        String ver = Main.class.getPackage().getImplementationVersion();
        return ver == null ? "UNKNOWN" : ver;
    }

    private static class EnumConverter<T extends Enum<T>>
    extends joptsimple.util.EnumConverter<T> {
        private EnumConverter(Class<T> enumClazz) {
            super(enumClazz);
        }
    }
}

