/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin;

import de.corneliusmay.silkspawners.api.Bukkit;
import de.corneliusmay.silkspawners.api.ServerPlatform;
import de.corneliusmay.silkspawners.plugin.bukkit.Metrics;
import de.corneliusmay.silkspawners.plugin.commands.EntitiesCommand;
import de.corneliusmay.silkspawners.plugin.commands.ExplosionCommand;
import de.corneliusmay.silkspawners.plugin.commands.GiveCommand;
import de.corneliusmay.silkspawners.plugin.commands.LocaleCommand;
import de.corneliusmay.silkspawners.plugin.commands.SetCommand;
import de.corneliusmay.silkspawners.plugin.commands.VersionCommand;
import de.corneliusmay.silkspawners.plugin.commands.handler.SilkSpawnersCommandHandler;
import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigLoader;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import de.corneliusmay.silkspawners.plugin.listeners.BlockBreakListener;
import de.corneliusmay.silkspawners.plugin.listeners.BlockPlaceListener;
import de.corneliusmay.silkspawners.plugin.listeners.PlayerInteractListener;
import de.corneliusmay.silkspawners.plugin.listeners.SpawnerBreakListener;
import de.corneliusmay.silkspawners.plugin.listeners.handler.SilkSpawnersEventHandler;
import de.corneliusmay.silkspawners.plugin.locale.LocaleHandler;
import de.corneliusmay.silkspawners.plugin.platform.PlatformLoader;
import de.corneliusmay.silkspawners.plugin.utils.Logger;
import de.corneliusmay.silkspawners.plugin.version.CrossVersionHandler;
import de.corneliusmay.silkspawners.plugin.version.VersionChecker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SilkSpawners
extends JavaPlugin {
    private Logger log;
    private ServerPlatform platform;
    private Bukkit bukkitHandler;
    private LocaleHandler locale;
    private VersionChecker versionChecker;

    public void onEnable() {
        new ConfigLoader((Plugin)this).load();
        this.log = new Logger((String)new ConfigValue(PluginConfig.MESSAGE_PREFIX).get());
        this.versionChecker = new VersionChecker(this);
        if (((Boolean)new ConfigValue(PluginConfig.UPDATE_CHECK_ENABLED).get()).booleanValue()) {
            this.versionChecker.start((Integer)new ConfigValue(PluginConfig.UPDATE_CHECK_INTERVAL).get());
        } else {
            this.log.warn("Update checking is disabled");
        }
        this.log.info("Starting SilkSpawners v" + this.versionChecker.getInstalledVersion());
        this.log.info("Loading server platform");
        PlatformLoader platformLoader = new PlatformLoader(this);
        platformLoader.load();
        this.platform = platformLoader.getServerPlatform();
        this.log.info("Loading Cross-Version support");
        CrossVersionHandler versionHandler = new CrossVersionHandler(this);
        if (!versionHandler.load()) {
            return;
        }
        this.bukkitHandler = versionHandler.getBukkitHandler();
        this.log.info("Loading locale file");
        this.locale = new LocaleHandler(this, (Locale)new ConfigValue(PluginConfig.MESSAGE_LOCALE).get());
        if (this.locale.getResourceBundle() == null) {
            return;
        }
        this.log.info("Starting bStats integration");
        new Metrics(this, 15215);
        this.log.info("Registering listeners");
        this.registerListeners();
        this.log.info("Registering commands");
        this.registerCommands();
        this.log.info("Started SilkSpawners v" + this.versionChecker.getInstalledVersion());
    }

    private void registerListeners() {
        List<Block> editedSpawners = Collections.synchronizedList(new ArrayList());
        SilkSpawnersEventHandler eventHandler = new SilkSpawnersEventHandler(this);
        eventHandler.registerListener(new PlayerInteractListener(editedSpawners));
        eventHandler.registerListener(new BlockPlaceListener(editedSpawners));
        eventHandler.registerListener(new BlockBreakListener());
        eventHandler.registerListener(new SpawnerBreakListener());
    }

    private void registerCommands() {
        SilkSpawnersCommandHandler commandHandler = new SilkSpawnersCommandHandler(this, "silkspawners");
        commandHandler.addCommand(new GiveCommand());
        commandHandler.addCommand(new SetCommand());
        commandHandler.addCommand(new ExplosionCommand());
        commandHandler.addCommand(new VersionCommand());
        commandHandler.addCommand(new LocaleCommand());
        commandHandler.addCommand(new EntitiesCommand());
        commandHandler.register();
    }

    public void onDisable() {
        if (this.versionChecker == null) {
            return;
        }
        this.log.info("Stopping version checker");
        this.versionChecker.stop();
    }

    @Generated
    public Logger getLog() {
        return this.log;
    }

    @Generated
    public ServerPlatform getPlatform() {
        return this.platform;
    }

    @Generated
    public Bukkit getBukkitHandler() {
        return this.bukkitHandler;
    }

    @Generated
    public LocaleHandler getLocale() {
        return this.locale;
    }

    @Generated
    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }
}

