/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands;

import de.corneliusmay.silkspawners.plugin.commands.completers.EntityTabCompleter;
import de.corneliusmay.silkspawners.plugin.commands.completers.OnlinePlayersTabCompleter;
import de.corneliusmay.silkspawners.plugin.commands.handler.SilkSpawnersCommand;
import de.corneliusmay.silkspawners.plugin.spawner.Spawner;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GiveCommand
extends SilkSpawnersCommand {
    public GiveCommand() {
        super("give", true, new OnlinePlayersTabCompleter(), new EntityTabCompleter());
    }

    @Override
    protected boolean execute(CommandSender sender, String[] args) {
        String trailingLetter;
        EntityType entityType;
        if (args.length < 2 || args.length > 3) {
            return this.invalidSyntax(sender);
        }
        Player p = Bukkit.getPlayer((String)args[0]);
        if (p == null) {
            this.sendMessage(sender, "PLAYER_NOT_FOUND", args[0]);
            return false;
        }
        if (args[1].equalsIgnoreCase(Spawner.EMPTY)) {
            entityType = null;
        } else {
            entityType = EntityType.fromName((String)args[1]);
            if (entityType == null) {
                this.sendMessage(sender, "ENTITY_NOT_FOUND", args[1]);
                return false;
            }
        }
        Spawner spawner = new Spawner(this.plugin, entityType);
        if (!spawner.isValid()) {
            this.sendMessage(sender, "ENTITY_NOT_FOUND", args[1]);
            return false;
        }
        if (!sender.hasPermission(this.getPermissionString() + "." + spawner.serializedEntityType()) && !sender.hasPermission(this.getPermissionString() + ".*")) {
            this.sendMessage(sender, "INSUFFICIENT_ENTITY_PERMISSION", spawner.serializedName());
            return false;
        }
        int amount = 1;
        if (args.length == 3) {
            amount = this.parseAmount(args[2]);
        }
        if (amount == -1) {
            this.sendMessage(sender, "INVALID_AMOUNT", args[2]);
            return false;
        }
        if (amount < 1) {
            this.sendMessage(sender, "TOO_SMALL_AMOUNT", new Object[0]);
            return false;
        }
        ItemStack item = spawner.getItemStack();
        item.setAmount(amount);
        p.getInventory().addItem(new ItemStack[]{item});
        String string = trailingLetter = amount > 1 ? "s" : "";
        if (p != sender) {
            this.sendMessage(sender, "SUCCESS", amount, spawner.serializedName(), trailingLetter, p.getName());
            this.sendMessage(p, "SUCCESS_TARGET", amount, spawner.serializedName(), trailingLetter, sender.getName());
        } else {
            this.sendMessage(sender, "SUCCESS_SELF", amount, spawner.serializedName(), trailingLetter);
        }
        return true;
    }

    private Integer parseAmount(String amount) {
        try {
            return Integer.parseInt(amount);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

