/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands;

import de.corneliusmay.silkspawners.plugin.commands.completers.EntityTabCompleter;
import de.corneliusmay.silkspawners.plugin.commands.handler.SilkSpawnersCommand;
import de.corneliusmay.silkspawners.plugin.spawner.Spawner;
import java.util.ArrayList;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class SetCommand
extends SilkSpawnersCommand {
    public SetCommand() {
        super("set", true, new EntityTabCompleter());
    }

    @Override
    protected boolean execute(CommandSender sender, String[] args) {
        EntityType entityType;
        if (args.length != 1) {
            return this.invalidSyntax(sender);
        }
        if (!(sender instanceof Player)) {
            this.sendMessage(sender, "PLAYERS_ONLY", new Object[0]);
            return false;
        }
        Player player = (Player)sender;
        if (args[0].equalsIgnoreCase(Spawner.EMPTY)) {
            entityType = null;
        } else {
            entityType = EntityType.fromName((String)args[0]);
            if (entityType == null) {
                this.sendMessage(sender, "ENTITY_NOT_FOUND", args[0]);
                return false;
            }
        }
        Spawner newSpawner = new Spawner(this.plugin, entityType);
        if (!newSpawner.isValid()) {
            this.sendMessage(sender, "ENTITY_NOT_FOUND", args[0]);
            return false;
        }
        if (!player.hasPermission(this.getPermissionString() + "." + newSpawner.serializedEntityType()) && !sender.hasPermission(this.getPermissionString() + ".*")) {
            this.sendMessage(sender, "INSUFFICIENT_ENTITY_PERMISSION", newSpawner.serializedName());
            return false;
        }
        Block block = this.plugin.getBukkitHandler().getTargetBlock(player);
        Spawner spawner = new Spawner(this.plugin, block);
        if (!spawner.isValid()) {
            this.sendMessage(sender, "INVALID_TARGET", new Object[0]);
            return false;
        }
        newSpawner.setSpawnerBlockType(block, new ArrayList<Block>());
        this.sendMessage(sender, "SUCCESS", newSpawner.serializedName());
        return true;
    }
}

