/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.commands.handler;

import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.commands.handler.HelpCommand;
import de.corneliusmay.silkspawners.plugin.commands.handler.SilkSpawnersCommand;
import de.corneliusmay.silkspawners.plugin.commands.handler.SilkSpawnersTabCompleter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;

public class SilkSpawnersCommandHandler
implements CommandExecutor {
    private final SilkSpawners plugin;
    private final String mainCommand;
    private final SilkSpawnersCommand helpCommand;
    private SilkSpawnersCommand defaultCommand;
    private final List<SilkSpawnersCommand> commands;
    private final SilkSpawnersTabCompleter tabCompleter;

    public SilkSpawnersCommandHandler(SilkSpawners plugin, String command) {
        this.plugin = plugin;
        this.mainCommand = command;
        this.commands = new ArrayList<SilkSpawnersCommand>();
        this.tabCompleter = new SilkSpawnersTabCompleter(this);
        this.helpCommand = this.addHelpCommand();
    }

    public SilkSpawnersCommandHandler(SilkSpawners plugin, String command, SilkSpawnersCommand defaultCommand) {
        this.plugin = plugin;
        this.mainCommand = command;
        this.commands = new ArrayList<SilkSpawnersCommand>();
        this.tabCompleter = new SilkSpawnersTabCompleter(this);
        this.helpCommand = this.addHelpCommand();
        this.defaultCommand = this.addDefaultCommand(defaultCommand);
    }

    public boolean onCommand(CommandSender commandSender, Command c, String s, String[] args) {
        if (args.length < 1) {
            if (this.defaultCommand == null || !this.defaultCommand.hasPermission(commandSender)) {
                return this.helpCommand.execute(commandSender, new String[0]);
            }
            return this.defaultCommand.execute(commandSender, new String[0]);
        }
        SilkSpawnersCommand command = this.getCommand(args[0]);
        if (command == null) {
            commandSender.sendMessage(this.plugin.getLocale().getMessage("COMMAND_NOT_FOUND", this.getAvailableCommandsString(commandSender)));
            return false;
        }
        if (!command.hasPermission(commandSender)) {
            return command.insufficientPermission(commandSender);
        }
        return command.execute(commandSender, Arrays.copyOfRange(args, 1, args.length));
    }

    public void addCommand(SilkSpawnersCommand command) {
        if (this.getCommand(command.getCommand()) != null) {
            return;
        }
        command.setCommandHandler(this);
        command.setPlugin(this.plugin);
        this.commands.add(command);
    }

    private SilkSpawnersCommand addHelpCommand() {
        HelpCommand help = new HelpCommand(this);
        this.addCommand(help);
        return help;
    }

    private SilkSpawnersCommand addDefaultCommand(SilkSpawnersCommand command) {
        this.addCommand(command);
        return command;
    }

    public void register() {
        PluginCommand command = this.plugin.getCommand(this.mainCommand);
        if (command == null) {
            throw new RuntimeException("Command is not registered in plugin.yml");
        }
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this.tabCompleter);
    }

    public SilkSpawnersCommand getCommand(String command) {
        return this.commands.stream().filter(c -> c.getCommand().equalsIgnoreCase(command)).findFirst().orElse(null);
    }

    public List<String> getCommands(CommandSender cs) {
        return this.commands.stream().filter(c -> c.hasPermission(cs)).map(SilkSpawnersCommand::getCommand).collect(Collectors.toList());
    }

    public String getAvailableCommandsString(CommandSender cs) {
        return " - /" + this.mainCommand + " " + Arrays.toString(this.getCommands(cs).toArray(String[]::new)).replace("[", "").replace("]", "").replace(", ", "\n - /" + this.mainCommand + " ");
    }

    @Generated
    String getMainCommand() {
        return this.mainCommand;
    }
}

