/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.config.handler;

import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import java.io.File;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigLoader {
    private final Plugin plugin;
    private final FileConfiguration config;

    public ConfigLoader(Plugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    private int getConfigVersion() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            Bukkit.getLogger().log(Level.INFO, "[SilkSpawners] No config file was found. The config will be generated with the default configuration");
            return 2;
        }
        int currentVersion = this.config.getInt("update.configVersion");
        if (currentVersion == 0) {
            currentVersion = 1;
        }
        if (2 > currentVersion) {
            this.config.set("update.configVersion", (Object)2);
            Bukkit.getLogger().log(Level.WARNING, "[SilkSpawners] Configuration file in version " + currentVersion + " is automatically converted to the latest version 2");
        } else {
            Bukkit.getLogger().log(Level.INFO, "[SilkSpawners] Configuration is up to date");
        }
        return currentVersion;
    }

    public void load() {
        Bukkit.getLogger().log(Level.INFO, "[SilkSpawners] Loading configuration...");
        int configVersion = this.getConfigVersion();
        for (PluginConfig value : PluginConfig.values()) {
            value.init(this.config, configVersion);
        }
        this.config.options().copyDefaults(true);
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
        for (PluginConfig value : PluginConfig.values()) {
            try {
                new ConfigValue(value).get();
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("Disabling plugin due to invalid configuration value: " + value.getPath() + ": " + this.config.getString(value.getPath()));
                this.plugin.getPluginLoader().disablePlugin(this.plugin);
            }
        }
    }
}

