/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.listeners;

import de.corneliusmay.silkspawners.plugin.config.PluginConfig;
import de.corneliusmay.silkspawners.plugin.config.handler.ConfigValue;
import de.corneliusmay.silkspawners.plugin.events.SpawnerPlaceEvent;
import de.corneliusmay.silkspawners.plugin.listeners.handler.SilkSpawnersListener;
import de.corneliusmay.silkspawners.plugin.spawner.Spawner;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;

public class BlockPlaceListener
extends SilkSpawnersListener<BlockPlaceEvent> {
    private final List<Block> editedSpawners;

    public BlockPlaceListener(List<Block> editedSpawners) {
        this.editedSpawners = editedSpawners;
    }

    @Override
    @EventHandler(priority=EventPriority.HIGHEST)
    protected void onCall(BlockPlaceEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Player p = e.getPlayer();
        ItemStack[] itemsInHand = this.plugin.getBukkitHandler().getItemsInHand(p);
        Spawner spawner = new Spawner(this.plugin, this.itemIsSpawner(itemsInHand));
        if (!spawner.isValid()) {
            return;
        }
        if (!(p.hasPermission("silkspawners.place." + spawner.serializedEntityType()) || p.hasPermission("silkspawners.place.*") || ((Boolean)new ConfigValue(PluginConfig.SPAWNER_PERMISSION_DISABLE_PLACE).get()).booleanValue())) {
            e.setCancelled(true);
            if (((Boolean)new ConfigValue(PluginConfig.SPAWNER_MESSAGE_DENY_PLACE).get()).booleanValue()) {
                p.sendMessage(this.plugin.getLocale().getMessage("SPAWNER_PLACE_DENIED", new Object[0]));
            }
            return;
        }
        SpawnerPlaceEvent event = new SpawnerPlaceEvent(p, spawner, e.getBlock().getLocation(), this.plugin);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            e.setCancelled(true);
            return;
        }
        this.editedSpawners.add(e.getBlock());
        event.getSpawner().setSpawnerBlockType(e.getBlock(), this.editedSpawners);
    }

    private ItemStack itemIsSpawner(ItemStack[] items) {
        return this.itemIsSpawner(items, 0);
    }

    private ItemStack itemIsSpawner(ItemStack[] items, int i) {
        if (items.length == i) {
            return null;
        }
        if (items[i].getType() == this.plugin.getBukkitHandler().getSpawnerMaterial()) {
            return items[i];
        }
        return this.itemIsSpawner(items, i + 1);
    }
}

