/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.version;

import de.corneliusmay.silkspawners.api.Bukkit;
import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import de.corneliusmay.silkspawners.plugin.version.MinecraftVersion;
import de.corneliusmay.silkspawners.plugin.version.MinecraftVersionChecker;
import lombok.Generated;
import org.bukkit.plugin.Plugin;

public class CrossVersionHandler {
    private final SilkSpawners plugin;
    private Bukkit bukkitHandler;

    public CrossVersionHandler(SilkSpawners plugin) {
        this.plugin = plugin;
    }

    private boolean disablePlugin(String message) {
        this.plugin.getLog().error(message);
        this.plugin.getLog().warn("Disabling plugin due to version incompatibility");
        this.plugin.getPluginLoader().disablePlugin((Plugin)this.plugin);
        return false;
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        return Class.forName("de.corneliusmay.silkspawners." + className);
    }

    public boolean load() {
        String bukkitVersion = MinecraftVersionChecker.getBukkitVersion();
        if (bukkitVersion == null) {
            return this.disablePlugin("The detected Server Version (" + MinecraftVersion.getVersion() + ") is too old for the currently installed version of SilkSpawners");
        }
        try {
            Class<?> clazz = this.loadClass("bukkit." + bukkitVersion + ".BukkitHandler");
            this.bukkitHandler = (Bukkit)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.plugin.getLog().info("Loaded support for version " + MinecraftVersion.getVersion());
        return true;
    }

    @Generated
    public Bukkit getBukkitHandler() {
        return this.bukkitHandler;
    }
}

