/*
 * Decompiled with CFR 0.152.
 */
package de.corneliusmay.silkspawners.plugin.version;

import com.google.common.base.Preconditions;
import de.corneliusmay.silkspawners.plugin.SilkSpawners;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class VersionChecker {
    private final SilkSpawners plugin;
    private final HttpClient client;
    private String latestVersion;
    private Thread thread;

    public VersionChecker(SilkSpawners plugin) {
        this.plugin = plugin;
        this.client = HttpClient.newHttpClient();
    }

    public void start(int interval) {
        Preconditions.checkState((this.thread == null ? 1 : 0) != 0);
        this.thread = new Thread(() -> this.run(interval));
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
    }

    private void run(int interval) {
        try {
            while (true) {
                this.plugin.getLog().info("Checking for updates");
                if (!this.update()) {
                    this.plugin.getLog().error("Error getting latest version");
                } else if (!this.check()) {
                    this.plugin.getLog().warn("\u00a7eUpdate available! Download at https://www.spigotmc.org/resources/silkspawners.60063/ \u00a7f\nInstalled version: v" + this.getInstalledVersion() + "\nLatest version: v" + this.latestVersion);
                } else {
                    this.plugin.getLog().info("The plugin is up to date (Current release v" + this.latestVersion + ")");
                }
                TimeUnit.HOURS.sleep(interval);
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private boolean update() throws InterruptedException {
        try {
            Pattern pattern = Pattern.compile("\"tag_name\":\"v([0-9\\.]+)\"");
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.github.com/repos/CorneliusMa/SilkSpawners_v2/releases/latest")).GET().build();
            String latestVersionData = this.client.send(request, HttpResponse.BodyHandlers.ofString()).body();
            Matcher matcher = pattern.matcher(latestVersionData);
            if (matcher.find()) {
                this.latestVersion = matcher.group(1);
                return true;
            }
            return false;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean check() {
        Integer[] installedVersion = this.castVersionString(this.getInstalledVersion());
        Integer[] latestVersion = this.castVersionString(this.latestVersion);
        for (int i = 0; i < latestVersion.length; ++i) {
            if (i >= installedVersion.length) {
                return true;
            }
            if (latestVersion[i] <= installedVersion[i]) continue;
            return false;
        }
        return true;
    }

    public String getInstalledVersion() {
        return this.plugin.getDescription().getVersion();
    }

    private Integer[] castVersionString(String version) {
        return (Integer[])Arrays.stream(version.split("\\.")).map(Integer::parseInt).toArray(Integer[]::new);
    }

    @Generated
    public String getLatestVersion() {
        return this.latestVersion;
    }
}

