/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public final class EntityUtil {
    private static final ThreadLocal<DecimalFormat> THREE_DECIMAL_PLACES = ThreadLocal.withInitial(() -> new DecimalFormat("#,##0.000"));

    private static String formatVec(Vec3D vec) {
        DecimalFormat format = THREE_DECIMAL_PLACES.get();
        return "(" + format.format(vec.d) + "," + format.format(vec.e) + "," + format.format(vec.f) + ")";
    }

    private static String dumpEntityWithoutReferences(Entity entity) {
        if (entity == null) {
            return "{null}";
        }
        return "{type=" + entity.getClass().getSimpleName() + ",id=" + entity.ao() + ",uuid=" + String.valueOf(entity.cG()) + ",pos=" + EntityUtil.formatVec(entity.dt()) + ",mot=" + EntityUtil.formatVec(entity.dy()) + ",aabb=" + String.valueOf(entity.cR()) + ",removed=" + String.valueOf((Object)entity.dR()) + ",has_vehicle=" + (entity.dk() != null) + ",passenger_count=" + entity.cY().size();
    }

    public static String dumpEntity(Entity entity) {
        List<Entity> passengers = entity.cY();
        ArrayList<CallSite> passengerStrings = new ArrayList<CallSite>(passengers.size());
        for (Entity passenger : passengers) {
            passengerStrings.add((CallSite)((Object)("(" + EntityUtil.dumpEntityWithoutReferences(passenger) + ")")));
        }
        return "{root=[" + EntityUtil.dumpEntityWithoutReferences(entity) + "], vehicle=[" + EntityUtil.dumpEntityWithoutReferences(entity.dk()) + "], passengers=[" + String.join((CharSequence)",", passengerStrings) + "]";
    }

    private EntityUtil() {
    }
}

