/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import ca.spottedleaf.concurrentutil.executor.thread.PrioritisedThreadPool;
import ca.spottedleaf.moonrise.common.PlatformHooks;
import com.mojang.logging.LogUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class MoonriseCommon {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    public static final PrioritisedThreadPool WORKER_POOL = new PrioritisedThreadPool((Consumer)new Consumer<Thread>(){
        private final AtomicInteger idGenerator = new AtomicInteger();

        @Override
        public void accept(Thread thread) {
            thread.setDaemon(true);
            thread.setName(PlatformHooks.get().getBrand() + " Common Worker #" + this.idGenerator.getAndIncrement());
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    LOGGER.error("Uncaught exception in thread " + thread.getName(), throwable);
                }
            });
        }
    });
    public static final long WORKER_QUEUE_HOLD_TIME = 20000000L;
    public static final int CLIENT_DIVISION = 0;
    public static final PrioritisedThreadPool.ExecutorGroup RENDER_EXECUTOR_GROUP = WORKER_POOL.createExecutorGroup(0, 0);
    public static final int SERVER_DIVISION = 1;
    public static final PrioritisedThreadPool.ExecutorGroup PARALLEL_GEN_GROUP = WORKER_POOL.createExecutorGroup(1, 0);
    public static final PrioritisedThreadPool.ExecutorGroup RADIUS_AWARE_GROUP = WORKER_POOL.createExecutorGroup(1, 0);
    public static final PrioritisedThreadPool.ExecutorGroup LOAD_GROUP = WORKER_POOL.createExecutorGroup(1, 0);
    public static final PrioritisedThreadPool IO_POOL = new PrioritisedThreadPool((Consumer)new Consumer<Thread>(){
        private final AtomicInteger idGenerator = new AtomicInteger();

        @Override
        public void accept(Thread thread) {
            thread.setDaemon(true);
            thread.setName(PlatformHooks.get().getBrand() + " I/O Worker #" + this.idGenerator.getAndIncrement());
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){

                @Override
                public void uncaughtException(Thread thread, Throwable throwable) {
                    LOGGER.error("Uncaught exception in thread " + thread.getName(), throwable);
                }
            });
        }
    });
    public static final long IO_QUEUE_HOLD_TIME = 100000000L;
    public static final PrioritisedThreadPool.ExecutorGroup CLIENT_PROFILER_IO_GROUP = IO_POOL.createExecutorGroup(0, 0);
    public static final PrioritisedThreadPool.ExecutorGroup SERVER_REGION_IO_GROUP = IO_POOL.createExecutorGroup(1, 0);

    public static void adjustWorkerThreads(int configWorkerThreads, int configIoThreads) {
        int defaultWorkerThreads = Runtime.getRuntime().availableProcessors() / 2;
        defaultWorkerThreads = defaultWorkerThreads <= 4 ? (defaultWorkerThreads <= 3 ? 1 : 2) : (defaultWorkerThreads /= 2);
        defaultWorkerThreads = Integer.getInteger(PlatformHooks.get().getBrand() + ".WorkerThreadCount", (Integer)defaultWorkerThreads);
        int workerThreads = configWorkerThreads;
        if (workerThreads <= 0) {
            workerThreads = defaultWorkerThreads;
        }
        int ioThreads = Math.max(1, configIoThreads);
        WORKER_POOL.adjustThreadCount(workerThreads);
        IO_POOL.adjustThreadCount(ioThreads);
        LOGGER.info(PlatformHooks.get().getBrand() + " is using " + workerThreads + " worker threads, " + ioThreads + " I/O threads");
    }

    public static void haltExecutors() {
        WORKER_POOL.shutdown(false);
        LOGGER.info("Awaiting termination of worker pool for up to 60s...");
        if (!WORKER_POOL.join(TimeUnit.SECONDS.toMillis(60L))) {
            LOGGER.error("Worker pool did not shut down in time!");
            WORKER_POOL.halt(false);
        }
        IO_POOL.shutdown(false);
        LOGGER.info("Awaiting termination of I/O pool for up to 60s...");
        if (!IO_POOL.join(TimeUnit.SECONDS.toMillis(60L))) {
            LOGGER.error("I/O pool did not shut down in time!");
            IO_POOL.halt(false);
        }
    }

    private MoonriseCommon() {
    }
}

