/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.level.entity.client;

import ca.spottedleaf.moonrise.common.PlatformHooks;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.ChunkEntitySlices;
import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.entity.LevelCallback;

public final class ClientEntityLookup
extends EntityLookup {
    private final LongOpenHashSet tickingChunks = new LongOpenHashSet();

    public ClientEntityLookup(World world, LevelCallback<Entity> worldCallback) {
        super(world, worldCallback);
    }

    @Override
    protected Boolean blockTicketUpdates() {
        return null;
    }

    @Override
    protected void setBlockTicketUpdates(Boolean value) {
    }

    @Override
    protected void checkThread(int chunkX, int chunkZ, String reason) {
    }

    @Override
    protected void checkThread(Entity entity, String reason) {
    }

    @Override
    protected ChunkEntitySlices createEntityChunk(int chunkX, int chunkZ, boolean transientChunk) {
        boolean ticking = this.tickingChunks.contains(CoordinateUtils.getChunkKey(chunkX, chunkZ));
        ChunkEntitySlices ret = new ChunkEntitySlices(this.world, chunkX, chunkZ, ticking ? FullChunkStatus.d : FullChunkStatus.b, null, WorldUtil.getMinSection(this.world), WorldUtil.getMaxSection(this.world));
        this.addChunk(chunkX, chunkZ, ret);
        return ret;
    }

    @Override
    protected void onEmptySlices(int chunkX, int chunkZ) {
        this.removeChunk(chunkX, chunkZ);
    }

    @Override
    protected void entitySectionChangeCallback(Entity entity, int oldSectionX, int oldSectionY, int oldSectionZ, int newSectionX, int newSectionY, int newSectionZ) {
        PlatformHooks.get().entityMove(entity, CoordinateUtils.getChunkSectionKey(oldSectionX, oldSectionY, oldSectionZ), CoordinateUtils.getChunkSectionKey(newSectionX, newSectionY, newSectionZ));
    }

    @Override
    protected void addEntityCallback(Entity entity) {
    }

    @Override
    protected void removeEntityCallback(Entity entity) {
    }

    @Override
    protected void entityStartLoaded(Entity entity) {
    }

    @Override
    protected void entityEndLoaded(Entity entity) {
    }

    @Override
    protected void entityStartTicking(Entity entity) {
    }

    @Override
    protected void entityEndTicking(Entity entity) {
    }

    @Override
    protected boolean screenEntity(Entity entity, boolean fromDisk, boolean event) {
        return true;
    }

    public void markTicking(long pos) {
        int chunkZ;
        int chunkX;
        if (this.tickingChunks.add(pos) && this.getChunk(chunkX = CoordinateUtils.getChunkX(pos), chunkZ = CoordinateUtils.getChunkZ(pos)) != null) {
            this.chunkStatusChange(chunkX, chunkZ, FullChunkStatus.d);
        }
    }

    public void markNonTicking(long pos) {
        int chunkZ;
        int chunkX;
        if (this.tickingChunks.remove(pos) && this.getChunk(chunkX = CoordinateUtils.getChunkX(pos), chunkZ = CoordinateUtils.getChunkZ(pos)) != null) {
            this.chunkStatusChange(chunkX, chunkZ, FullChunkStatus.b);
        }
    }
}

