/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.brigadier.suggestion;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import java.util.Objects;

public class IntegerSuggestion
extends Suggestion {
    private int value;

    public IntegerSuggestion(StringRange range, int value) {
        this(range, value, null);
    }

    public IntegerSuggestion(StringRange range, int value, Message tooltip) {
        super(range, Integer.toString(value), tooltip);
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof IntegerSuggestion)) {
            return false;
        }
        IntegerSuggestion that = (IntegerSuggestion)o2;
        return this.value == that.value && super.equals(o2);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String toString() {
        return "IntegerSuggestion{value=" + this.value + ", range=" + String.valueOf(this.getRange()) + ", text='" + this.getText() + "', tooltip='" + String.valueOf(this.getTooltip()) + "'}";
    }

    @Override
    public int compareTo(Suggestion o2) {
        return super.compareTo(o2);
    }

    @Override
    public int compareToIgnoreCase(Suggestion b2) {
        return super.compareToIgnoreCase(b2);
    }
}

