/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Quaternionf;

public record GivensParameters(float a, float b) {
    private final float a;
    private final float b;

    public static GivensParameters a(float sinHalf, float cosHalf) {
        float f2 = Math.invsqrt((float)(sinHalf * sinHalf + cosHalf * cosHalf));
        return new GivensParameters(f2 * sinHalf, f2 * cosHalf);
    }

    public static GivensParameters a(float angle) {
        float f2 = Math.sin((float)(angle / 2.0f));
        float f1 = Math.cosFromSin((float)f2, (float)(angle / 2.0f));
        return new GivensParameters(f2, f1);
    }

    public GivensParameters a() {
        return new GivensParameters(-this.a, this.b);
    }

    public Quaternionf a(Quaternionf quaternion) {
        return quaternion.set(this.a, 0.0f, 0.0f, this.b);
    }

    public Quaternionf b(Quaternionf quaternion) {
        return quaternion.set(0.0f, this.a, 0.0f, this.b);
    }

    public Quaternionf c(Quaternionf quaternion) {
        return quaternion.set(0.0f, 0.0f, this.a, this.b);
    }

    public float b() {
        return this.b * this.b - this.a * this.a;
    }

    public float c() {
        return 2.0f * this.a * this.b;
    }

    public Matrix3f a(Matrix3f matrix) {
        matrix.m01 = 0.0f;
        matrix.m02 = 0.0f;
        matrix.m10 = 0.0f;
        matrix.m20 = 0.0f;
        float f2 = this.b();
        float f1 = this.c();
        matrix.m11 = f2;
        matrix.m22 = f2;
        matrix.m12 = f1;
        matrix.m21 = -f1;
        matrix.m00 = 1.0f;
        return matrix;
    }

    public Matrix3f b(Matrix3f matrix) {
        matrix.m01 = 0.0f;
        matrix.m10 = 0.0f;
        matrix.m12 = 0.0f;
        matrix.m21 = 0.0f;
        float f2 = this.b();
        float f1 = this.c();
        matrix.m00 = f2;
        matrix.m22 = f2;
        matrix.m02 = -f1;
        matrix.m20 = f1;
        matrix.m11 = 1.0f;
        return matrix;
    }

    public Matrix3f c(Matrix3f matrix) {
        matrix.m02 = 0.0f;
        matrix.m12 = 0.0f;
        matrix.m20 = 0.0f;
        matrix.m21 = 0.0f;
        float f2 = this.b();
        float f1 = this.c();
        matrix.m00 = f2;
        matrix.m11 = f2;
        matrix.m01 = f1;
        matrix.m10 = -f1;
        matrix.m22 = 1.0f;
        return matrix;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GivensParameters.class, "sinHalf;cosHalf", "a", "b"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GivensParameters.class, "sinHalf;cosHalf", "a", "b"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GivensParameters.class, "sinHalf;cosHalf", "a", "b"}, this, o2);
    }

    public float d() {
        return this.a;
    }

    public float e() {
        return this.b;
    }
}

