/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.MatrixUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.ExtraCodecs;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class Transformation {
    private final Matrix4fc c;
    public static final Codec<Transformation> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.c.fieldOf("translation").forGetter(transformation -> transformation.e), (App)ExtraCodecs.g.fieldOf("left_rotation").forGetter(transformation -> transformation.f), (App)ExtraCodecs.c.fieldOf("scale").forGetter(transformation -> transformation.g), (App)ExtraCodecs.g.fieldOf("right_rotation").forGetter(transformation -> transformation.h)).apply((Applicative)instance, Transformation::new));
    public static final Codec<Transformation> b = Codec.withAlternative(a, (Codec)ExtraCodecs.h.xmap(Transformation::new, Transformation::c));
    private boolean d;
    @Nullable
    private Vector3f e;
    @Nullable
    private Quaternionf f;
    @Nullable
    private Vector3f g;
    @Nullable
    private Quaternionf h;
    private static final Transformation i = SystemUtils.a(() -> {
        Transformation transformation = new Transformation((Matrix4fc)new Matrix4f());
        transformation.e = new Vector3f();
        transformation.f = new Quaternionf();
        transformation.g = new Vector3f(1.0f, 1.0f, 1.0f);
        transformation.h = new Quaternionf();
        transformation.d = true;
        return transformation;
    });

    public Transformation(@Nullable Matrix4fc matrix) {
        this.c = matrix == null ? new Matrix4f() : matrix;
    }

    public Transformation(@Nullable Vector3f translation, @Nullable Quaternionf leftRotation, @Nullable Vector3f scale, @Nullable Quaternionf rightRotation) {
        this.c = Transformation.a(translation, leftRotation, scale, rightRotation);
        this.e = translation != null ? translation : new Vector3f();
        this.f = leftRotation != null ? leftRotation : new Quaternionf();
        this.g = scale != null ? scale : new Vector3f(1.0f, 1.0f, 1.0f);
        this.h = rightRotation != null ? rightRotation : new Quaternionf();
        this.d = true;
    }

    public static Transformation a() {
        return i;
    }

    public Transformation a(Transformation other) {
        Matrix4f matrixCopy = this.d();
        matrixCopy.mul(other.c());
        return new Transformation((Matrix4fc)matrixCopy);
    }

    @Nullable
    public Transformation b() {
        if (this == i) {
            return this;
        }
        Matrix4f matrix4f = this.d().invertAffine();
        return matrix4f.isFinite() ? new Transformation((Matrix4fc)matrix4f) : null;
    }

    private void i() {
        if (!this.d) {
            float f2 = 1.0f / this.c.m33();
            Triple<Quaternionf, Vector3f, Quaternionf> triple = MatrixUtil.a(new Matrix3f(this.c).scale(f2));
            this.e = this.c.getTranslation(new Vector3f()).mul(f2);
            this.f = new Quaternionf((Quaternionfc)triple.getLeft());
            this.g = new Vector3f((Vector3fc)triple.getMiddle());
            this.h = new Quaternionf((Quaternionfc)triple.getRight());
            this.d = true;
        }
    }

    private static Matrix4f a(@Nullable Vector3f translation, @Nullable Quaternionf leftRotation, @Nullable Vector3f scale, @Nullable Quaternionf rightRotation) {
        Matrix4f matrix4f = new Matrix4f();
        if (translation != null) {
            matrix4f.translation((Vector3fc)translation);
        }
        if (leftRotation != null) {
            matrix4f.rotate((Quaternionfc)leftRotation);
        }
        if (scale != null) {
            matrix4f.scale((Vector3fc)scale);
        }
        if (rightRotation != null) {
            matrix4f.rotate((Quaternionfc)rightRotation);
        }
        return matrix4f;
    }

    public Matrix4fc c() {
        return this.c;
    }

    public Matrix4f d() {
        return new Matrix4f(this.c);
    }

    public Vector3f e() {
        this.i();
        return new Vector3f((Vector3fc)this.e);
    }

    public Quaternionf f() {
        this.i();
        return new Quaternionf((Quaternionfc)this.f);
    }

    public Vector3f g() {
        this.i();
        return new Vector3f((Vector3fc)this.g);
    }

    public Quaternionf h() {
        this.i();
        return new Quaternionf((Quaternionfc)this.h);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            Transformation transformation = (Transformation)other;
            return Objects.equals(this.c, transformation.c);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.c);
    }

    public Transformation a(Transformation transformation, float delta) {
        Vector3f translation = this.e();
        Quaternionf leftRotation = this.f();
        Vector3f scale = this.g();
        Quaternionf rightRotation = this.h();
        translation.lerp((Vector3fc)transformation.e(), delta);
        leftRotation.slerp((Quaternionfc)transformation.f(), delta);
        scale.lerp((Vector3fc)transformation.g(), delta);
        rightRotation.slerp((Quaternionfc)transformation.h(), delta);
        return new Transformation(translation, leftRotation, scale, rightRotation);
    }
}

