/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.block.fluid;

import com.google.common.base.Preconditions;
import io.papermc.paper.block.fluid.FluidData;
import io.papermc.paper.block.fluid.type.PaperFallingFluidData;
import io.papermc.paper.block.fluid.type.PaperFlowingFluidData;
import org.bukkit.Fluid;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R4.CraftFluid;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftVector;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class PaperFluidData
implements FluidData {
    private final net.minecraft.world.level.material.Fluid state;

    protected PaperFluidData(net.minecraft.world.level.material.Fluid state) {
        this.state = state;
    }

    public net.minecraft.world.level.material.Fluid getState() {
        return this.state;
    }

    @NotNull
    public final Fluid getFluidType() {
        return CraftFluid.minecraftToBukkit(this.state.a());
    }

    @NotNull
    public PaperFluidData clone() {
        try {
            return (PaperFluidData)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError("Clone not supported", ex);
        }
    }

    @NotNull
    public Vector computeFlowDirection(Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Cannot compute flow direction on world-less location");
        return CraftVector.toBukkit(this.state.c(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toBlockPosition(location)));
    }

    public int getLevel() {
        return this.state.e();
    }

    public float computeHeight(@NotNull Location location) {
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"Cannot compute height on world-less location");
        return this.state.a(((CraftWorld)location.getWorld()).getHandle(), CraftLocation.toBlockPosition(location));
    }

    public boolean isSource() {
        return this.state.b();
    }

    public int hashCode() {
        return this.state.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof PaperFluidData)) return false;
        PaperFluidData paperFluidData = (PaperFluidData)obj;
        if (!this.state.equals(paperFluidData.state)) return false;
        return true;
    }

    public String toString() {
        return "PaperFluidData{" + String.valueOf(this.state) + "}";
    }

    public static PaperFluidData createData(net.minecraft.world.level.material.Fluid state) {
        if (state.c()) {
            return new PaperFluidData(state);
        }
        return state.b() ? new PaperFallingFluidData(state) : new PaperFlowingFluidData(state);
    }
}

