/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.ConfigurationPart;
import io.papermc.paper.configuration.Configurations;
import io.papermc.paper.configuration.NestedSetting;
import io.papermc.paper.configuration.legacy.MaxEntityCollisionsInitializer;
import io.papermc.paper.configuration.legacy.RequiresSpigotInitialization;
import io.papermc.paper.configuration.mapping.MergeMap;
import io.papermc.paper.configuration.serializer.NbtPathSerializer;
import io.papermc.paper.configuration.serializer.collections.MapSerializer;
import io.papermc.paper.configuration.type.BooleanOrDefault;
import io.papermc.paper.configuration.type.DespawnRange;
import io.papermc.paper.configuration.type.Duration;
import io.papermc.paper.configuration.type.DurationOrDisabled;
import io.papermc.paper.configuration.type.EngineMode;
import io.papermc.paper.configuration.type.fallback.ArrowDespawnRate;
import io.papermc.paper.configuration.type.fallback.AutosavePeriod;
import io.papermc.paper.configuration.type.number.BelowZeroToEmpty;
import io.papermc.paper.configuration.type.number.DoubleOr;
import io.papermc.paper.configuration.type.number.IntOr;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.SystemUtils;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityVindicator;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import org.slf4j.Logger;
import org.spigotmc.SpigotWorldConfig;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;
import org.spongepowered.configurate.objectmapping.meta.PostProcess;
import org.spongepowered.configurate.objectmapping.meta.Required;
import org.spongepowered.configurate.objectmapping.meta.Setting;
import org.spongepowered.configurate.serialize.SerializationException;

public class WorldConfiguration
extends ConfigurationPart {
    private static final Logger LOGGER = LogUtils.getClassLogger();
    static final int CURRENT_VERSION = 31;
    private final transient SpigotWorldConfig spigotConfig;
    private final transient MinecraftKey worldKey;
    @Setting(value="_version")
    public int version = 31;
    public Anticheat anticheat;
    public Entities entities;
    public Lootables lootables;
    public MaxGrowthHeight maxGrowthHeight;
    public Scoreboards scoreboards;
    public Environment environment;
    public Spawn spawn;
    public Maps maps;
    public Fixes fixes;
    public UnsupportedSettings unsupportedSettings;
    public Hopper hopper;
    public Collisions collisions;
    public Chunks chunks;
    public FishingTimeRange fishingTimeRange;
    public TickRates tickRates;
    @Setting(value="feature-seeds")
    public FeatureSeeds featureSeeds;
    public CommandBlocks commandBlocks;
    public Misc misc;

    WorldConfiguration(SpigotWorldConfig spigotConfig, MinecraftKey worldKey) {
        this.spigotConfig = spigotConfig;
        this.worldKey = worldKey;
    }

    public boolean isDefault() {
        return this.worldKey.equals(Configurations.WORLD_DEFAULTS_KEY);
    }

    public class Misc
    extends ConfigurationPart {
        public boolean updatePathfindingOnBlockUpdate = true;
        public boolean showSignClickCommandFailureMsgsToPlayer = false;
        public RedstoneImplementation redstoneImplementation = RedstoneImplementation.VANILLA;
        public AlternateCurrentUpdateOrder alternateCurrentUpdateOrder = AlternateCurrentUpdateOrder.HORIZONTAL_FIRST_OUTWARD;
        public boolean disableEndCredits = false;
        public DoubleOr.Default maxLeashDistance = DoubleOr.Default.USE_DEFAULT;
        public boolean disableSprintInterruptionOnAttack = false;
        public int shieldBlockingDelay = 5;
        public boolean disableRelativeProjectileVelocity = false;
        public boolean legacyEnderPearlBehavior = false;

        public Misc(WorldConfiguration this$0) {
        }

        public static enum RedstoneImplementation {
            VANILLA,
            EIGENCRAFT,
            ALTERNATE_CURRENT;

        }

        public static enum AlternateCurrentUpdateOrder {
            HORIZONTAL_FIRST_OUTWARD,
            HORIZONTAL_FIRST_INWARD,
            VERTICAL_FIRST_OUTWARD,
            VERTICAL_FIRST_INWARD;

        }
    }

    public class CommandBlocks
    extends ConfigurationPart {
        public int permissionsLevel = 2;
        public boolean forceFollowPermLevel = true;

        public CommandBlocks(WorldConfiguration this$0) {
        }
    }

    public class FeatureSeeds
    extends ConfigurationPart {
        @Setting(value="generate-random-seeds-for-all")
        public boolean generateRandomSeedsForAll = false;
        @Setting(value="features")
        public Reference2LongMap<Holder<WorldGenFeatureConfigured<?, ?>>> features = new Reference2LongOpenHashMap();

        public FeatureSeeds(WorldConfiguration this$0) {
        }

        @PostProcess
        private void postProcess() {
            this.features.defaultReturnValue(-1L);
        }
    }

    public class TickRates
    extends ConfigurationPart {
        public int grassSpread = 1;
        public int containerUpdate = 1;
        public int mobSpawner = 1;
        public int wetFarmland = 1;
        public int dryFarmland = 1;
        public Table<EntityTypes<?>, String, Integer> sensor = (Table)SystemUtils.a(HashBasedTable.create(), table -> table.put(EntityTypes.bE, (Object)"secondarypoisensor", (Object)40));
        public Table<EntityTypes<?>, String, Integer> behavior = (Table)SystemUtils.a(HashBasedTable.create(), table -> table.put(EntityTypes.bE, (Object)"validatenearbypoi", (Object)-1));

        public TickRates(WorldConfiguration this$0) {
        }
    }

    public class FishingTimeRange
    extends ConfigurationPart {
        public int minimum = 100;
        public int maximum = 600;

        public FishingTimeRange(WorldConfiguration this$0) {
        }
    }

    public class Chunks
    extends ConfigurationPart {
        public AutosavePeriod autoSaveInterval = AutosavePeriod.def();
        public int maxAutoSaveChunksPerTick = 24;
        public int fixedChunkInhabitedTime = -1;
        public boolean preventMovingIntoUnloadedChunks = false;
        public Duration delayChunkUnloadsBy = Duration.of("10s");
        public Reference2IntMap<EntityTypes<?>> entityPerChunkSaveLimit = (Reference2IntMap)SystemUtils.a(new Reference2IntOpenHashMap(BuiltInRegistries.f.d()), map -> {
            map.defaultReturnValue(-1);
            map.put(EntityTypes.W, -1);
            map.put(EntityTypes.bl, -1);
            map.put(EntityTypes.R, -1);
            map.put(EntityTypes.h, -1);
            map.put(EntityTypes.Z, -1);
            map.put(EntityTypes.bj, -1);
        });
        public boolean flushRegionsOnSave = false;

        public Chunks(WorldConfiguration this$0) {
        }
    }

    public class Collisions
    extends ConfigurationPart {
        public boolean onlyPlayersCollide = false;
        public boolean allowVehicleCollisions = true;
        public boolean fixClimbingBypassingCrammingRule = false;
        @RequiresSpigotInitialization(value=MaxEntityCollisionsInitializer.class)
        public int maxEntityCollisions = 8;
        public boolean allowPlayerCrammingDamage = false;

        public Collisions(WorldConfiguration this$0) {
        }
    }

    public class Hopper
    extends ConfigurationPart {
        public boolean cooldownWhenFull = true;
        public boolean disableMoveEvent = false;
        public boolean ignoreOccludingBlocks = false;

        public Hopper(WorldConfiguration this$0) {
        }
    }

    public class UnsupportedSettings
    extends ConfigurationPart {
        public boolean fixInvulnerableEndCrystalExploit = true;
        public boolean disableWorldTickingWhenEmpty = false;

        public UnsupportedSettings(WorldConfiguration this$0) {
        }
    }

    public class Fixes
    extends ConfigurationPart {
        public boolean fixItemsMergingThroughWalls = false;
        public boolean disableUnloadedChunkEnderpearlExploit = false;
        public boolean preventTntFromMovingInWater = false;
        public boolean splitOverstackedLoot = true;
        public IntOr.Disabled fallingBlockHeightNerf = IntOr.Disabled.DISABLED;
        public IntOr.Disabled tntEntityHeightNerf = IntOr.Disabled.DISABLED;

        public Fixes(WorldConfiguration this$0) {
        }
    }

    public class Maps
    extends ConfigurationPart {
        public int itemFrameCursorLimit = 128;
        public int itemFrameCursorUpdateInterval = 10;

        public Maps(WorldConfiguration this$0) {
        }
    }

    public class Spawn
    extends ConfigurationPart {
        public boolean allowUsingSignsInsideSpawnProtection = false;

        public Spawn(WorldConfiguration this$0) {
        }
    }

    public class Environment
    extends ConfigurationPart {
        public boolean disableThunder = false;
        public boolean disableIceAndSnow = false;
        public boolean optimizeExplosions = false;
        public boolean disableExplosionKnockback = false;
        public boolean generateFlatBedrock = false;
        public FrostedIce frostedIce;
        public DoubleOr.Disabled voidDamageAmount = new DoubleOr.Disabled(OptionalDouble.of(4.0));
        public double voidDamageMinBuildHeightOffset = -64.0;
        public TreasureMaps treasureMaps;
        public int fireTickDelay = 30;
        public int waterOverLavaFlowSpeed = 5;
        public int portalSearchRadius = 128;
        public int portalCreateRadius = 16;
        public boolean portalSearchVanillaDimensionScaling = true;
        public IntOr.Disabled netherCeilingVoidDamageHeight = IntOr.Disabled.DISABLED;
        public int maxFluidTicks = 65536;
        public int maxBlockTicks = 65536;
        public boolean locateStructuresOutsideWorldBorder = false;

        public Environment(WorldConfiguration this$0) {
        }

        public class TreasureMaps
        extends ConfigurationPart {
            public boolean enabled = true;
            @NestedSetting(value={"find-already-discovered", "villager-trade"})
            public boolean findAlreadyDiscoveredVillager = false;
            @NestedSetting(value={"find-already-discovered", "loot-tables"})
            public BooleanOrDefault findAlreadyDiscoveredLootTable = BooleanOrDefault.USE_DEFAULT;

            public TreasureMaps(Environment this$1) {
            }
        }

        public class FrostedIce
        extends ConfigurationPart {
            public boolean enabled = true;
            public Delay delay;

            public FrostedIce(Environment this$1) {
            }

            public class Delay
            extends ConfigurationPart {
                public int min = 20;
                public int max = 40;

                public Delay(FrostedIce this$2) {
                }
            }
        }
    }

    public class Scoreboards
    extends ConfigurationPart {
        public boolean allowNonPlayerEntitiesOnScoreboards = true;
        public boolean useVanillaWorldScoreboardNameColoring = false;

        public Scoreboards(WorldConfiguration this$0) {
        }
    }

    public class MaxGrowthHeight
    extends ConfigurationPart {
        public int cactus = 3;
        public int reeds = 3;
        public Bamboo bamboo;

        public MaxGrowthHeight(WorldConfiguration this$0) {
        }

        public class Bamboo
        extends ConfigurationPart {
            public int max = 16;
            public int min = 11;

            public Bamboo(MaxGrowthHeight this$1) {
            }
        }
    }

    public class Lootables
    extends ConfigurationPart {
        public boolean autoReplenish = false;
        public boolean restrictPlayerReloot = true;
        public DurationOrDisabled restrictPlayerRelootTime = DurationOrDisabled.USE_DISABLED;
        public boolean resetSeedOnFill = true;
        public int maxRefills = -1;
        public Duration refreshMin = Duration.of("12h");
        public Duration refreshMax = Duration.of("2d");
        public boolean retainUnlootedShulkerBoxLootTableOnNonPlayerBreak = true;

        public Lootables(WorldConfiguration this$0) {
        }
    }

    public class Entities
    extends ConfigurationPart {
        public MobEffects mobEffects;
        public ArmorStands armorStands;
        public Markers markers;
        public Sniffer sniffer;
        public Spawning spawning;
        public Behavior behavior;
        public TrackingRangeY trackingRangeY;

        public class TrackingRangeY
        extends ConfigurationPart {
            public boolean enabled = false;
            public IntOr.Default player = IntOr.Default.USE_DEFAULT;
            public IntOr.Default animal = IntOr.Default.USE_DEFAULT;
            public IntOr.Default monster = IntOr.Default.USE_DEFAULT;
            public IntOr.Default misc = IntOr.Default.USE_DEFAULT;
            public IntOr.Default display = IntOr.Default.USE_DEFAULT;
            public IntOr.Default other = IntOr.Default.USE_DEFAULT;

            public TrackingRangeY(Entities this$1) {
            }

            public int get(Entity entity, int def) {
                if (entity instanceof EntityEnderDragon) {
                    return -1;
                }
                if (entity instanceof Display) {
                    return this.display.or(def);
                }
                if (entity instanceof EntityHuman) {
                    return this.player.or(def);
                }
                if (entity instanceof EntityHanging || entity instanceof EntityItem || entity instanceof EntityExperienceOrb) {
                    return this.misc.or(def);
                }
                switch (entity.activationType) {
                    case ANIMAL: 
                    case WATER: 
                    case VILLAGER: {
                        return this.animal.or(def);
                    }
                    case MONSTER: 
                    case FLYING_MONSTER: 
                    case RAIDER: {
                        return this.monster.or(def);
                    }
                }
                return this.other.or(def);
            }
        }

        public class Behavior
        extends ConfigurationPart {
            public boolean disableChestCatDetection = false;
            public boolean spawnerNerfedMobsShouldJump = false;
            public int experienceMergeMaxValue = -1;
            public boolean shouldRemoveDragon = false;
            public boolean zombiesTargetTurtleEggs = true;
            public boolean piglinsGuardChests = true;
            public double babyZombieMovementModifier = 0.5;
            public boolean allowSpiderWorldBorderClimbing = true;
            private static final List<EntityTypes<?>> ZOMBIE_LIKE = List.of(EntityTypes.bP, EntityTypes.an, EntityTypes.bR, EntityTypes.bS);
            @MergeMap
            public Map<EntityTypes<?>, List<EnumDifficulty>> doorBreakingDifficulty = SystemUtils.a(new IdentityHashMap(), map -> {
                for (EntityTypes<?> type : ZOMBIE_LIKE) {
                    map.put(type, Arrays.stream(EnumDifficulty.values()).filter(EntityZombie.bS).toList());
                }
                map.put(EntityTypes.bF, Arrays.stream(EnumDifficulty.values()).filter(EntityVindicator.b).toList());
            });
            public boolean disableCreeperLingeringEffect = false;
            public boolean enderDragonsDeathAlwaysPlacesDragonEgg = false;
            public boolean phantomsDoNotSpawnOnCreativePlayers = true;
            public boolean phantomsOnlyAttackInsomniacs = true;
            public int playerInsomniaStartTicks = 72000;
            public int phantomsSpawnAttemptMinSeconds = 60;
            public int phantomsSpawnAttemptMaxSeconds = 119;
            public boolean parrotsAreUnaffectedByPlayerMovement = false;
            @BelowZeroToEmpty
            public DoubleOr.Default zombieVillagerInfectionChance = DoubleOr.Default.USE_DEFAULT;
            public MobsCanAlwaysPickUpLoot mobsCanAlwaysPickUpLoot;
            public boolean disablePlayerCrits = false;
            public boolean nerfPigmenFromNetherPortals = false;
            @Comment(value="Prevents merging items that are not on the same y level, preventing potential visual artifacts.")
            public boolean onlyMergeItemsHorizontally = false;
            public PillagerPatrols pillagerPatrols;
            @Comment(value="Adds a cooldown to bees being released after a failed release, which can occur if the hive is blocked or it being night.")
            public boolean cooldownFailedBeehiveReleases = true;

            public Behavior(Entities this$1) {
            }

            public class PillagerPatrols
            extends ConfigurationPart {
                public boolean disable = false;
                public double spawnChance = 0.2;
                public SpawnDelay spawnDelay;
                public Start start;

                public PillagerPatrols(Behavior this$2) {
                }

                public class Start
                extends ConfigurationPart {
                    public boolean perPlayer = false;
                    public int day = 5;

                    public Start(PillagerPatrols this$3) {
                    }
                }

                public class SpawnDelay
                extends ConfigurationPart {
                    public boolean perPlayer = false;
                    public int ticks = 12000;

                    public SpawnDelay(PillagerPatrols this$3) {
                    }
                }
            }

            public class MobsCanAlwaysPickUpLoot
            extends ConfigurationPart {
                public boolean zombies = false;
                public boolean skeletons = false;

                public MobsCanAlwaysPickUpLoot(Behavior this$2) {
                }
            }
        }

        public class Spawning
        extends ConfigurationPart {
            public ArrowDespawnRate nonPlayerArrowDespawnRate;
            public ArrowDespawnRate creativeArrowDespawnRate;
            public boolean filterBadTileEntityNbtFromFallingBlocks;
            public List<ArgumentNBTKey.g> filteredEntityTagNbtPaths;
            public boolean disableMobSpawnerSpawnEggTransformation;
            public boolean perPlayerMobSpawns;
            public boolean scanForLegacyEnderDragon;
            @MergeMap
            public Reference2IntMap<EnumCreatureType> spawnLimits;
            @MergeMap
            public Map<EnumCreatureType, DespawnRangePair> despawnRanges;
            public DespawnRange.Shape despawnRangeShape;
            @MergeMap
            public Reference2IntMap<EnumCreatureType> ticksPerSpawn;
            @MapSerializer.ThrowExceptions
            public Reference2ObjectMap<EntityTypes<?>, IntOr.Disabled> despawnTime;
            public WaterAnimalSpawnHeight wateranimalSpawnHeight;
            public SlimeSpawnHeight slimeSpawnHeight;
            public WanderingTrader wanderingTrader;
            public boolean allChunksAreSlimeChunks;
            @BelowZeroToEmpty
            public DoubleOr.Default skeletonHorseThunderSpawnChance;
            public boolean ironGolemsCanSpawnInAir;
            public boolean countAllMobsForSpawning;
            @BelowZeroToEmpty
            public IntOr.Default monsterSpawnMaxLightLevel;
            public DuplicateUUID duplicateUuid;
            public AltItemDespawnRate altItemDespawnRate;

            public Spawning() {
                this.nonPlayerArrowDespawnRate = ArrowDespawnRate.def(WorldConfiguration.this.spigotConfig);
                this.creativeArrowDespawnRate = ArrowDespawnRate.def(WorldConfiguration.this.spigotConfig);
                this.filterBadTileEntityNbtFromFallingBlocks = true;
                this.filteredEntityTagNbtPaths = NbtPathSerializer.fromString(List.of("Pos", "Motion", "sleeping_pos"));
                this.disableMobSpawnerSpawnEggTransformation = false;
                this.perPlayerMobSpawns = true;
                this.scanForLegacyEnderDragon = true;
                this.spawnLimits = (Reference2IntMap)SystemUtils.a(new Reference2IntOpenHashMap(SpawnerCreature.g.length), map -> Arrays.stream(SpawnerCreature.g).forEach(mobCategory -> map.put(mobCategory, -1)));
                this.despawnRanges = Arrays.stream(EnumCreatureType.values()).collect(Collectors.toMap(Function.identity(), category -> DespawnRangePair.createDefault()));
                this.despawnRangeShape = DespawnRange.Shape.ELLIPSOID;
                this.ticksPerSpawn = (Reference2IntMap)SystemUtils.a(new Reference2IntOpenHashMap(SpawnerCreature.g.length), map -> Arrays.stream(SpawnerCreature.g).forEach(mobCategory -> map.put(mobCategory, -1)));
                this.despawnTime = (Reference2ObjectMap)SystemUtils.a(new Reference2ObjectOpenHashMap(), map -> {
                    map.put(EntityTypes.bl, (Object)IntOr.Disabled.DISABLED);
                    map.put(EntityTypes.az, (Object)IntOr.Disabled.DISABLED);
                });
                this.allChunksAreSlimeChunks = false;
                this.skeletonHorseThunderSpawnChance = DoubleOr.Default.USE_DEFAULT;
                this.ironGolemsCanSpawnInAir = false;
                this.countAllMobsForSpawning = false;
                this.monsterSpawnMaxLightLevel = IntOr.Default.USE_DEFAULT;
            }

            @PostProcess
            public void precomputeDespawnDistances() throws SerializationException {
                for (Map.Entry<EnumCreatureType, DespawnRangePair> entry : this.despawnRanges.entrySet()) {
                    EnumCreatureType category = entry.getKey();
                    DespawnRangePair range = entry.getValue();
                    range.hard().preComputed(category.f(), category.c());
                    range.soft().preComputed(category.g(), category.c());
                }
            }

            @ConfigSerializable
            public record DespawnRangePair(@Required DespawnRange hard, @Required DespawnRange soft) {
                public static DespawnRangePair createDefault() {
                    return new DespawnRangePair(new DespawnRange(IntOr.Default.USE_DEFAULT), new DespawnRange(IntOr.Default.USE_DEFAULT));
                }
            }

            public class AltItemDespawnRate
            extends ConfigurationPart {
                public boolean enabled = false;
                public Reference2IntMap<Item> items = new Reference2IntOpenHashMap(Map.of(Items.J, 300));

                public AltItemDespawnRate(Spawning this$2) {
                }
            }

            public class DuplicateUUID
            extends ConfigurationPart {
                public DuplicateUUIDMode mode = DuplicateUUIDMode.SAFE_REGEN;
                public int safeRegenDeleteRange = 32;

                public DuplicateUUID(Spawning this$2) {
                }

                public static enum DuplicateUUIDMode {
                    SAFE_REGEN,
                    DELETE,
                    NOTHING,
                    WARN;

                }
            }

            public class WanderingTrader
            extends ConfigurationPart {
                public int spawnMinuteLength = 1200;
                public int spawnDayLength = 24000;
                public int spawnChanceFailureIncrement = 25;
                public int spawnChanceMin = 25;
                public int spawnChanceMax = 75;

                public WanderingTrader(Spawning this$2) {
                }
            }

            public class SlimeSpawnHeight
            extends ConfigurationPart {
                public SurfaceSpawnableSlimeBiome surfaceBiome;
                public SlimeChunk slimeChunk;

                public SlimeSpawnHeight(Spawning this$2) {
                }

                public class SlimeChunk
                extends ConfigurationPart {
                    public double maximum = 40.0;

                    public SlimeChunk(SlimeSpawnHeight this$3) {
                    }
                }

                public class SurfaceSpawnableSlimeBiome
                extends ConfigurationPart {
                    public double maximum = 70.0;
                    public double minimum = 50.0;

                    public SurfaceSpawnableSlimeBiome(SlimeSpawnHeight this$3) {
                    }
                }
            }

            public class WaterAnimalSpawnHeight
            extends ConfigurationPart {
                public IntOr.Default maximum = IntOr.Default.USE_DEFAULT;
                public IntOr.Default minimum = IntOr.Default.USE_DEFAULT;

                public WaterAnimalSpawnHeight(Spawning this$2) {
                }
            }
        }

        public class Sniffer
        extends ConfigurationPart {
            public IntOr.Default hatchTime = IntOr.Default.USE_DEFAULT;
            public IntOr.Default boostedHatchTime = IntOr.Default.USE_DEFAULT;

            public Sniffer(Entities this$1) {
            }
        }

        public class Markers
        extends ConfigurationPart {
            public boolean tick = true;

            public Markers(Entities this$1) {
            }
        }

        public class ArmorStands
        extends ConfigurationPart {
            public boolean doCollisionEntityLookups = true;
            public boolean tick = true;

            public ArmorStands(Entities this$1) {
            }
        }

        public class MobEffects
        extends ConfigurationPart {
            public boolean spidersImmuneToPoisonEffect = true;
            public ImmuneToWitherEffect immuneToWitherEffect;

            public MobEffects(Entities this$1) {
            }

            public class ImmuneToWitherEffect
            extends ConfigurationPart {
                public boolean wither = true;
                public boolean witherSkeleton = true;

                public ImmuneToWitherEffect(MobEffects this$2) {
                }
            }
        }
    }

    public class Anticheat
    extends ConfigurationPart {
        public AntiXray antiXray;

        public Anticheat(WorldConfiguration this$0) {
        }

        public class AntiXray
        extends ConfigurationPart {
            public boolean enabled = false;
            public EngineMode engineMode = EngineMode.HIDE;
            public int maxBlockHeight = 64;
            public int updateRadius = 2;
            public boolean lavaObscures = false;
            public boolean usePermission = false;
            public List<Block> hiddenBlocks = List.of(Blocks.rI, Blocks.rJ, Blocks.tQ, Blocks.Q, Blocks.R, Blocks.S, Blocks.T, Blocks.tP, Blocks.U, Blocks.V, Blocks.aY, Blocks.aZ, Blocks.cx, Blocks.cy, Blocks.cG, Blocks.cI, Blocks.cJ, Blocks.dY, Blocks.dZ, Blocks.ei, Blocks.gd, Blocks.ge, Blocks.gf);
            public List<Block> replacementBlocks = List.of(Blocks.b, Blocks.n, Blocks.tt);

            public AntiXray(Anticheat this$1) {
            }
        }
    }
}

