/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.mapping;

import io.leangen.geantyref.GenericTypeReflector;
import io.papermc.paper.configuration.ConfigurationPart;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.util.CheckedFunction;
import org.spongepowered.configurate.util.CheckedSupplier;

final class InnerClassInstanceSupplier
implements CheckedFunction<AnnotatedType, Supplier<Object>, SerializationException> {
    private final Map<Class<?>, Object> instanceMap = new HashMap();
    private final Map<Class<?>, Object> initialOverrides;

    InnerClassInstanceSupplier(Map<Class<?>, Object> initialOverrides) {
        this.initialOverrides = initialOverrides;
    }

    public Supplier<Object> apply(AnnotatedType target) throws SerializationException {
        Class type = GenericTypeReflector.erase((Type)target.getType());
        if (this.initialOverrides.containsKey(type)) {
            this.instanceMap.put(type, this.initialOverrides.get(type));
            return () -> this.initialOverrides.get(type);
        }
        if (ConfigurationPart.class.isAssignableFrom(type) && !this.instanceMap.containsKey(type)) {
            try {
                CheckedSupplier instanceSupplier;
                Constructor constructor;
                Object instance;
                if (type.getEnclosingClass() != null && !Modifier.isStatic(type.getModifiers())) {
                    instance = this.instanceMap.get(type.getEnclosingClass());
                    if (instance == null) {
                        throw new SerializationException("Cannot create a new instance of an inner class " + type.getName() + " without an instance of its enclosing class " + type.getEnclosingClass().getName());
                    }
                    constructor = type.getDeclaredConstructor(type.getEnclosingClass());
                    instanceSupplier = () -> constructor.newInstance(instance);
                } else {
                    constructor = type.getDeclaredConstructor(new Class[0]);
                    instanceSupplier = () -> constructor.newInstance(new Object[0]);
                }
                constructor.setAccessible(true);
                instance = instanceSupplier.get();
                this.instanceMap.put(type, instance);
                return () -> instance;
            }
            catch (ReflectiveOperationException e2) {
                throw new SerializationException(ConfigurationPart.class, String.valueOf(target) + " must be a valid ConfigurationPart", (Throwable)e2);
            }
        }
        throw new SerializationException(String.valueOf(target) + " must be a valid ConfigurationPart");
    }

    Map<Class<?>, Object> instanceMap() {
        return this.instanceMap;
    }
}

