/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.DataComponentAdapter;
import io.papermc.paper.datacomponent.item.PaperBannerPatternLayers;
import io.papermc.paper.datacomponent.item.PaperBlockItemDataProperties;
import io.papermc.paper.datacomponent.item.PaperBlocksAttacks;
import io.papermc.paper.datacomponent.item.PaperBundleContents;
import io.papermc.paper.datacomponent.item.PaperChargedProjectiles;
import io.papermc.paper.datacomponent.item.PaperConsumable;
import io.papermc.paper.datacomponent.item.PaperCustomModelData;
import io.papermc.paper.datacomponent.item.PaperDamageResistant;
import io.papermc.paper.datacomponent.item.PaperDeathProtection;
import io.papermc.paper.datacomponent.item.PaperDyedItemColor;
import io.papermc.paper.datacomponent.item.PaperEnchantable;
import io.papermc.paper.datacomponent.item.PaperEquippable;
import io.papermc.paper.datacomponent.item.PaperFireworks;
import io.papermc.paper.datacomponent.item.PaperFoodProperties;
import io.papermc.paper.datacomponent.item.PaperItemAdventurePredicate;
import io.papermc.paper.datacomponent.item.PaperItemArmorTrim;
import io.papermc.paper.datacomponent.item.PaperItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.PaperItemContainerContents;
import io.papermc.paper.datacomponent.item.PaperItemEnchantments;
import io.papermc.paper.datacomponent.item.PaperItemLore;
import io.papermc.paper.datacomponent.item.PaperItemTool;
import io.papermc.paper.datacomponent.item.PaperJukeboxPlayable;
import io.papermc.paper.datacomponent.item.PaperLodestoneTracker;
import io.papermc.paper.datacomponent.item.PaperMapDecorations;
import io.papermc.paper.datacomponent.item.PaperMapId;
import io.papermc.paper.datacomponent.item.PaperMapItemColor;
import io.papermc.paper.datacomponent.item.PaperOminousBottleAmplifier;
import io.papermc.paper.datacomponent.item.PaperPotDecorations;
import io.papermc.paper.datacomponent.item.PaperPotionContents;
import io.papermc.paper.datacomponent.item.PaperRepairable;
import io.papermc.paper.datacomponent.item.PaperResolvableProfile;
import io.papermc.paper.datacomponent.item.PaperSeededContainerLoot;
import io.papermc.paper.datacomponent.item.PaperSuspiciousStewEffects;
import io.papermc.paper.datacomponent.item.PaperTooltipDisplay;
import io.papermc.paper.datacomponent.item.PaperUseCooldown;
import io.papermc.paper.datacomponent.item.PaperUseRemainder;
import io.papermc.paper.datacomponent.item.PaperWeapon;
import io.papermc.paper.datacomponent.item.PaperWritableBookContent;
import io.papermc.paper.datacomponent.item.PaperWrittenBookContent;
import io.papermc.paper.item.MapPostProcessing;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.util.MCUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntitySalmon;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.component.InstrumentComponent;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_21_R4.CraftArt;
import org.bukkit.craftbukkit.v1_21_R4.CraftMusicInstrument;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftCat;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftChicken;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftCow;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftFrog;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPig;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftVillager;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftWolf;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_21_R4.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_21_R4.util.Handleable;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Salmon;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.ItemRarity;

public final class DataComponentAdapters {
    static final Function<Unit, Void> UNIT_TO_API_CONVERTER = $ -> {
        throw new UnsupportedOperationException("Cannot convert the Unit type to an API value");
    };
    static final Function UNIMPLEMENTED_TO_API_CONVERTER = $ -> {
        throw new UnsupportedOperationException("Cannot convert the an unimplemented type to an API value");
    };
    static final Map<ResourceKey<DataComponentType<?>>, DataComponentAdapter<?, ?>> ADAPTERS = new HashMap();

    public static void bootstrap() {
        DataComponentAdapters.registerIdentity(DataComponents.c);
        DataComponentAdapters.registerIdentity(DataComponents.d);
        DataComponentAdapters.registerIdentity(DataComponents.e);
        DataComponentAdapters.registerUntyped(DataComponents.f);
        DataComponentAdapters.registerIdentity(DataComponents.S);
        DataComponentAdapters.register(DataComponents.g, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.h, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.i, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.j, PaperItemLore::new);
        DataComponentAdapters.register(DataComponents.k, nms -> ItemRarity.valueOf((String)nms.name()), api -> EnumItemRarity.valueOf(api.name()));
        DataComponentAdapters.register(DataComponents.l, PaperItemEnchantments::new);
        DataComponentAdapters.register(DataComponents.m, PaperItemAdventurePredicate::new);
        DataComponentAdapters.register(DataComponents.n, PaperItemAdventurePredicate::new);
        DataComponentAdapters.register(DataComponents.o, PaperItemAttributeModifiers::new);
        DataComponentAdapters.register(DataComponents.p, PaperCustomModelData::new);
        DataComponentAdapters.registerIdentity(DataComponents.r);
        DataComponentAdapters.registerIdentity(DataComponents.t);
        DataComponentAdapters.registerUntyped(DataComponents.u);
        DataComponentAdapters.register(DataComponents.v, PaperFoodProperties::new);
        DataComponentAdapters.register(DataComponents.w, PaperConsumable::new);
        DataComponentAdapters.register(DataComponents.x, PaperUseRemainder::new);
        DataComponentAdapters.register(DataComponents.y, PaperUseCooldown::new);
        DataComponentAdapters.register(DataComponents.z, PaperDamageResistant::new);
        DataComponentAdapters.register(DataComponents.A, PaperItemTool::new);
        DataComponentAdapters.register(DataComponents.C, PaperEnchantable::new);
        DataComponentAdapters.register(DataComponents.D, PaperEquippable::new);
        DataComponentAdapters.register(DataComponents.E, PaperRepairable::new);
        DataComponentAdapters.registerUntyped(DataComponents.F);
        DataComponentAdapters.register(DataComponents.G, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.H, PaperDeathProtection::new);
        DataComponentAdapters.register(DataComponents.J, PaperItemEnchantments::new);
        DataComponentAdapters.register(DataComponents.K, PaperDyedItemColor::new);
        DataComponentAdapters.register(DataComponents.L, PaperMapItemColor::new);
        DataComponentAdapters.register(DataComponents.M, PaperMapId::new);
        DataComponentAdapters.register(DataComponents.N, PaperMapDecorations::new);
        DataComponentAdapters.register(DataComponents.O, nms -> MapPostProcessing.valueOf((String)nms.name()), api -> net.minecraft.world.item.component.MapPostProcessing.valueOf(api.name()));
        DataComponentAdapters.register(DataComponents.P, PaperChargedProjectiles::new);
        DataComponentAdapters.register(DataComponents.Q, PaperBundleContents::new);
        DataComponentAdapters.register(DataComponents.R, PaperPotionContents::new);
        DataComponentAdapters.register(DataComponents.T, PaperSuspiciousStewEffects::new);
        DataComponentAdapters.register(DataComponents.V, PaperWrittenBookContent::new);
        DataComponentAdapters.register(DataComponents.U, PaperWritableBookContent::new);
        DataComponentAdapters.register(DataComponents.W, PaperItemArmorTrim::new);
        DataComponentAdapters.register(DataComponents.ab, nms -> CraftMusicInstrument.minecraftHolderToBukkit(nms.a().a(CraftRegistry.getMinecraftRegistry()).orElseThrow()), api -> new InstrumentComponent(CraftMusicInstrument.bukkitToMinecraftHolder(api)));
        DataComponentAdapters.register(DataComponents.ac, nms -> CraftTrimMaterial.minecraftHolderToBukkit(nms.a().a(CraftRegistry.getMinecraftRegistry()).orElseThrow()), api -> new ProvidesTrimMaterial(CraftTrimMaterial.bukkitToMinecraftHolder(api)));
        DataComponentAdapters.register(DataComponents.ad, PaperOminousBottleAmplifier::new);
        DataComponentAdapters.register(DataComponents.ae, PaperJukeboxPlayable::new);
        DataComponentAdapters.register(DataComponents.af, PaperRegistries::fromNms, PaperRegistries::toNms);
        DataComponentAdapters.register(DataComponents.ag, nms -> MCUtil.transformUnmodifiable(nms, PaperAdventure::asAdventureKey), api -> MCUtil.transformUnmodifiable(api, key -> PaperAdventure.asVanilla(Registries.bv, key)));
        DataComponentAdapters.register(DataComponents.ah, PaperLodestoneTracker::new);
        DataComponentAdapters.register(DataComponents.ai, CraftMetaFirework::getEffect, CraftMetaFirework::getExplosion);
        DataComponentAdapters.register(DataComponents.aj, PaperFireworks::new);
        DataComponentAdapters.register(DataComponents.ak, PaperResolvableProfile::new);
        DataComponentAdapters.register(DataComponents.al, PaperAdventure::asAdventure, PaperAdventure::asVanilla);
        DataComponentAdapters.register(DataComponents.am, PaperBannerPatternLayers::new);
        DataComponentAdapters.register(DataComponents.an, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.ao, PaperPotDecorations::new);
        DataComponentAdapters.register(DataComponents.ap, PaperItemContainerContents::new);
        DataComponentAdapters.register(DataComponents.aq, PaperBlockItemDataProperties::new);
        DataComponentAdapters.register(DataComponents.at, PaperSeededContainerLoot::new);
        DataComponentAdapters.register(DataComponents.au, nms -> PaperAdventure.asAdventure(((SoundEffect)nms.a()).a()), PaperAdventure::resolveSound);
        DataComponentAdapters.register(DataComponents.q, PaperTooltipDisplay::new);
        DataComponentAdapters.register(DataComponents.B, PaperWeapon::new);
        DataComponentAdapters.register(DataComponents.I, PaperBlocksAttacks::new);
        DataComponentAdapters.register(DataComponents.av, CraftVillager.CraftType::minecraftHolderToBukkit, CraftVillager.CraftType::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aw, CraftWolf.CraftVariant::minecraftHolderToBukkit, CraftWolf.CraftVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.ay, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.ax, CraftWolf.CraftSoundVariant::minecraftHolderToBukkit, CraftWolf.CraftSoundVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.az, nms -> Fox.Type.values()[nms.ordinal()], api -> EntityFox.Type.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aA, nms -> Salmon.Variant.values()[nms.ordinal()], api -> EntitySalmon.Variant.values()[api.ordinal()]);
        DataComponentAdapters.register(DataComponents.aB, nms -> Parrot.Variant.values()[nms.ordinal()], api -> EntityParrot.Variant.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aC, nms -> TropicalFish.Pattern.values()[nms.ordinal()], api -> EntityTropicalFish.Variant.values()[api.ordinal()]);
        DataComponentAdapters.register(DataComponents.aD, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.aE, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.aF, nms -> MushroomCow.Variant.values()[nms.ordinal()], api -> EntityMushroomCow.Type.values()[api.ordinal()]);
        DataComponentAdapters.register(DataComponents.aG, nms -> Rabbit.Type.values()[nms.ordinal()], api -> EntityRabbit.Variant.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aH, CraftPig.CraftVariant::minecraftHolderToBukkit, CraftPig.CraftVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aI, CraftCow.CraftVariant::minecraftHolderToBukkit, CraftCow.CraftVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aJ, nms -> CraftChicken.CraftVariant.minecraftHolderToBukkit(nms.a(CraftRegistry.getMinecraftRegistry()).orElseThrow()), api -> new EitherHolder<ChickenVariant>(CraftChicken.CraftVariant.bukkitToMinecraftHolder(api)));
        DataComponentAdapters.register(DataComponents.aK, CraftFrog.CraftVariant::minecraftHolderToBukkit, CraftFrog.CraftVariant::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aL, nms -> Horse.Color.values()[nms.ordinal()], api -> HorseColor.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aM, CraftArt::minecraftHolderToBukkit, CraftArt::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aN, nms -> Llama.Color.values()[nms.ordinal()], api -> EntityLlama.Variant.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aO, nms -> Axolotl.Variant.values()[nms.ordinal()], api -> Axolotl.Variant.a(api.ordinal()));
        DataComponentAdapters.register(DataComponents.aP, CraftCat.CraftType::minecraftHolderToBukkit, CraftCat.CraftType::bukkitToMinecraftHolder);
        DataComponentAdapters.register(DataComponents.aQ, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.aR, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        DataComponentAdapters.register(DataComponents.aS, nms -> DyeColor.getByWoolData((byte)((byte)nms.a())), api -> EnumColor.a(api.getWoolData()));
        for (Map.Entry<ResourceKey<DataComponentType<?>>, DataComponentType<?>> componentType : BuiltInRegistries.am.k()) {
            if (ADAPTERS.containsKey(componentType.getKey())) continue;
            DataComponentAdapters.registerUnimplemented(componentType.getValue());
        }
    }

    public static void registerUntyped(DataComponentType<Unit> type) {
        DataComponentAdapters.registerInternal(type, UNIT_TO_API_CONVERTER, DataComponentAdapter.API_TO_UNIT_CONVERTER, false);
    }

    private static <COMMON> void registerIdentity(DataComponentType<COMMON> type) {
        DataComponentAdapters.registerInternal(type, Function.identity(), Function.identity(), true);
    }

    public static <NMS> void registerUnimplemented(DataComponentType<NMS> type) {
        DataComponentAdapters.registerInternal(type, UNIMPLEMENTED_TO_API_CONVERTER, DataComponentAdapter.API_TO_UNIMPLEMENTED_CONVERTER, false);
    }

    private static <NMS, API extends Handleable<NMS>> void register(DataComponentType<NMS> type, Function<NMS, API> vanillaToApi) {
        DataComponentAdapters.registerInternal(type, vanillaToApi, Handleable::getHandle, false);
    }

    private static <NMS, API> void register(DataComponentType<NMS> type, Function<NMS, API> vanillaToApi, Function<API, NMS> apiToVanilla) {
        DataComponentAdapters.registerInternal(type, vanillaToApi, apiToVanilla, false);
    }

    private static <NMS, API> void registerInternal(DataComponentType<NMS> type, Function<NMS, API> vanillaToApi, Function<API, NMS> apiToVanilla, boolean codecValidation) {
        ResourceKey<DataComponentType<NMS>> key = BuiltInRegistries.am.d(type).orElseThrow();
        if (ADAPTERS.containsKey(key)) {
            throw new IllegalStateException("Duplicate adapter registration for " + String.valueOf(key));
        }
        ADAPTERS.put(key, new DataComponentAdapter<NMS, API>(type, apiToVanilla, vanillaToApi, codecValidation && !type.d()));
    }
}

