/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.BlocksAttacks;
import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.tag.TagKey;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.item.component.BlocksAttacks;
import org.bukkit.craftbukkit.v1_21_R4.util.Handleable;
import org.bukkit.damage.DamageType;
import org.jetbrains.annotations.Nullable;

public record PaperBlocksAttacks(net.minecraft.world.item.component.BlocksAttacks impl) implements BlocksAttacks,
Handleable<net.minecraft.world.item.component.BlocksAttacks>
{
    @Override
    public net.minecraft.world.item.component.BlocksAttacks getHandle() {
        return this.impl;
    }

    public float blockDelaySeconds() {
        return this.impl.b();
    }

    public float disableCooldownScale() {
        return this.impl.c();
    }

    @Nullable
    public TagKey<DamageType> bypassedBy() {
        Optional<TagKey> tagKey = this.impl.f().map(PaperRegistries::fromNms);
        return tagKey.orElse(null);
    }

    @Nullable
    public Key blockSound() {
        return this.impl.g().map(holder -> PaperAdventure.asAdventure(((SoundEffect)holder.a()).a())).orElse(null);
    }

    @Nullable
    public Key disableSound() {
        return this.impl.h().map(holder -> PaperAdventure.asAdventure(((SoundEffect)holder.a()).a())).orElse(null);
    }

    static final class BuilderImpl
    implements BlocksAttacks.Builder {
        private float blockDelaySeconds;
        private float disableCooldownScale = 1.0f;
        @Nullable
        private TagKey<DamageType> bypassedBy;
        @Nullable
        private Key blockSound;
        @Nullable
        private Key disableSound;

        BuilderImpl() {
        }

        public BlocksAttacks.Builder blockDelaySeconds(float delay) {
            Preconditions.checkArgument((delay >= 0.0f ? 1 : 0) != 0, (String)"delay must be non-negative, was %s", (Object)Float.valueOf(delay));
            this.blockDelaySeconds = delay;
            return this;
        }

        public BlocksAttacks.Builder disableCooldownScale(float scale) {
            Preconditions.checkArgument((scale >= 0.0f ? 1 : 0) != 0, (String)"scale must be non-negative, was %s", (Object)Float.valueOf(scale));
            this.disableCooldownScale = scale;
            return this;
        }

        public BlocksAttacks.Builder bypassedBy(@Nullable TagKey<DamageType> bypassedBy) {
            this.bypassedBy = bypassedBy;
            return this;
        }

        public BlocksAttacks.Builder blockSound(@Nullable Key sound) {
            this.blockSound = sound;
            return this;
        }

        public BlocksAttacks.Builder disableSound(@Nullable Key sound) {
            this.disableSound = sound;
            return this;
        }

        public BlocksAttacks build() {
            return new PaperBlocksAttacks(new net.minecraft.world.item.component.BlocksAttacks(this.blockDelaySeconds, this.disableCooldownScale, List.of(), BlocksAttacks.b.c, Optional.ofNullable(this.bypassedBy).map(PaperRegistries::toNms), Optional.ofNullable(this.blockSound).map(PaperAdventure::resolveSound), Optional.ofNullable(this.disableSound).map(PaperAdventure::resolveSound)));
        }
    }
}

