/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.configuration.serializer;

import io.papermc.paper.plugin.provider.configuration.type.PermissionConfiguration;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;

public class PermissionConfigurationSerializer {
    public static final Serializer SERIALIZER = new Serializer();

    private static final class Serializer
    implements TypeSerializer<PermissionConfiguration> {
        private Serializer() {
        }

        public PermissionConfiguration deserialize(Type type, ConfigurationNode node) throws SerializationException {
            Map map = (Map)node.node(new Object[]{"permissions"}).raw();
            ConfigurationNode permNode = node.node(new Object[]{"defaultPerm"});
            PermissionDefault permissionDefault = permNode.virtual() ? PermissionDefault.OP : PermissionDefault.getByName((String)permNode.getString());
            ArrayList<Permission> result = new ArrayList<Permission>();
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    try {
                        result.add(Permission.loadPermission((String)entry.getKey().toString(), (Map)((Map)entry.getValue()), (PermissionDefault)permissionDefault, result));
                    }
                    catch (Throwable ex) {
                        throw new SerializationException((Type)null, "Error loading permission %s".formatted(entry.getKey()), ex);
                    }
                }
            }
            return new PermissionConfiguration(permissionDefault, List.copyOf(result));
        }

        public void serialize(Type type, @Nullable PermissionConfiguration obj, ConfigurationNode node) throws SerializationException {
        }
    }
}

