/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.DamageTypeRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.world.damagesource.DamageEffects;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DeathMessageType;
import org.bukkit.craftbukkit.v1_21_R4.damage.CraftDamageEffect;
import org.bukkit.craftbukkit.v1_21_R4.damage.CraftDamageType;
import org.bukkit.damage.DamageEffect;
import org.jspecify.annotations.Nullable;

public class PaperDamageTypeRegistryEntry
implements DamageTypeRegistryEntry {
    protected @Nullable String messageId;
    protected @Nullable Float exhaustion;
    protected @Nullable DamageScaling damageScaling;
    protected DamageEffects damageEffects = DamageEffects.a;
    protected DeathMessageType deathMessageType = DeathMessageType.a;
    protected final Conversions conversions;

    public PaperDamageTypeRegistryEntry(Conversions conversions, @Nullable DamageType internal) {
        this.conversions = conversions;
        if (internal == null) {
            return;
        }
        this.messageId = internal.a();
        this.exhaustion = Float.valueOf(internal.c());
        this.damageScaling = internal.b();
        this.damageEffects = internal.d();
        this.deathMessageType = internal.e();
    }

    public String messageId() {
        return Checks.asConfigured(this.messageId, "messsageId");
    }

    public float exhaustion() {
        return Checks.asConfigured(this.exhaustion, "exhaustion").floatValue();
    }

    public org.bukkit.damage.DamageScaling damageScaling() {
        return CraftDamageType.damageScalingToBukkit(Checks.asConfigured(this.damageScaling, "damageScaling"));
    }

    public DamageEffect damageEffect() {
        return CraftDamageEffect.toBukkit(this.damageEffects);
    }

    public org.bukkit.damage.DeathMessageType deathMessageType() {
        return CraftDamageType.deathMessageTypeToBukkit(this.deathMessageType);
    }

    public static final class PaperBuilder
    extends PaperDamageTypeRegistryEntry
    implements DamageTypeRegistryEntry.Builder,
    PaperRegistryBuilder<DamageType, org.bukkit.damage.DamageType> {
        public PaperBuilder(Conversions conversions, @Nullable DamageType internal) {
            super(conversions, internal);
        }

        public DamageTypeRegistryEntry.Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public DamageTypeRegistryEntry.Builder exhaustion(float exhaustion) {
            this.exhaustion = Float.valueOf(exhaustion);
            return this;
        }

        public DamageTypeRegistryEntry.Builder damageScaling(org.bukkit.damage.DamageScaling scaling) {
            this.damageScaling = CraftDamageType.damageScalingToNMS(scaling);
            return this;
        }

        public DamageTypeRegistryEntry.Builder damageEffect(DamageEffect effect) {
            this.damageEffects = ((CraftDamageEffect)effect).getHandle();
            return this;
        }

        public DamageTypeRegistryEntry.Builder deathMessageType(org.bukkit.damage.DeathMessageType deathMessageType) {
            this.deathMessageType = CraftDamageType.deathMessageTypeToNMS(deathMessageType);
            return this;
        }

        @Override
        public DamageType build() {
            return new DamageType(Checks.asConfigured(this.messageId, "messsageId"), Checks.asConfigured(this.damageScaling, "scaling"), Checks.asConfigured(this.exhaustion, "exhaustion").floatValue(), this.damageEffects, this.deathMessageType);
        }
    }
}

