/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.entry;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.entry.RegistryEntry;
import io.papermc.paper.registry.entry.RegistryEntryImpl;
import io.papermc.paper.registry.entry.RegistryEntryMeta;
import io.papermc.paper.registry.entry.RegistryTypeMapper;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.ResourceKey;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_21_R4.util.ApiVersion;

public class RegistryEntryBuilder<M, A extends Keyed> {
    protected final ResourceKey<? extends IRegistry<M>> mcKey;
    protected final RegistryKey<A> apiKey;

    public static <M, A extends Keyed> RegistryEntryBuilder<M, A> start(ResourceKey<? extends IRegistry<M>> mcKey, RegistryKey<A> apiKey) {
        return new RegistryEntryBuilder<M, A>(mcKey, apiKey);
    }

    private RegistryEntryBuilder(ResourceKey<? extends IRegistry<M>> mcKey, RegistryKey<A> apiKey) {
        this.mcKey = mcKey;
        this.apiKey = apiKey;
    }

    public RegistryEntry<M, A> apiOnly(Supplier<Registry<A>> apiRegistrySupplier) {
        return new RegistryEntryImpl(new RegistryEntryMeta.ApiOnly(this.mcKey, this.apiKey, apiRegistrySupplier));
    }

    public CraftStage<M, A> craft(Class<?> classToPreload, BiFunction<? super NamespacedKey, M, ? extends A> minecraftToBukkit) {
        return new CraftStage<M, A>(this.mcKey, this.apiKey, classToPreload, new RegistryTypeMapper<M, A>(minecraftToBukkit));
    }

    public CraftStage<M, A> craft(Class<?> classToPreload, Function<Holder<M>, ? extends A> minecraftToBukkit) {
        return this.craft(classToPreload, minecraftToBukkit, false);
    }

    public CraftStage<M, A> craft(Class<?> classToPreload, Function<Holder<M>, ? extends A> minecraftToBukkit, boolean allowDirect) {
        return new CraftStage<M, A>(this.mcKey, this.apiKey, classToPreload, new RegistryTypeMapper<M, A>(minecraftToBukkit, allowDirect));
    }

    public static final class CraftStage<M, A extends Keyed>
    extends RegistryEntryBuilder<M, A> {
        private static final BiFunction<NamespacedKey, ApiVersion, NamespacedKey> EMPTY = (namespacedKey, apiVersion) -> namespacedKey;
        private final Class<?> classToPreload;
        private final RegistryTypeMapper<M, A> minecraftToBukkit;
        private BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater = EMPTY;

        private CraftStage(ResourceKey<? extends IRegistry<M>> mcKey, RegistryKey<A> apiKey, Class<?> classToPreload, RegistryTypeMapper<M, A> minecraftToBukkit) {
            super(mcKey, apiKey);
            this.classToPreload = classToPreload;
            this.minecraftToBukkit = minecraftToBukkit;
        }

        public CraftStage<M, A> serializationUpdater(BiFunction<NamespacedKey, ApiVersion, NamespacedKey> serializationUpdater) {
            this.serializationUpdater = serializationUpdater;
            return this;
        }

        public RegistryEntry<M, A> build() {
            return new RegistryEntryImpl(new RegistryEntryMeta.Craft(this.mcKey, this.apiKey, this.classToPreload, this.minecraftToBukkit, this.serializationUpdater));
        }

        public <B extends PaperRegistryBuilder<M, A>> RegistryEntry<M, A> modifiable(PaperRegistryBuilder.Filler<M, A, B> filler) {
            return this.create(filler, RegistryEntryMeta.RegistryModificationApiSupport.MODIFIABLE);
        }

        public <B extends PaperRegistryBuilder<M, A>> RegistryEntry<M, A> addable(PaperRegistryBuilder.Filler<M, A, B> filler) {
            return this.create(filler, RegistryEntryMeta.RegistryModificationApiSupport.ADDABLE);
        }

        public <B extends PaperRegistryBuilder<M, A>> RegistryEntry<M, A> writable(PaperRegistryBuilder.Filler<M, A, B> filler) {
            return this.create(filler, RegistryEntryMeta.RegistryModificationApiSupport.WRITABLE);
        }

        private <B extends PaperRegistryBuilder<M, A>> RegistryEntry<M, A> create(PaperRegistryBuilder.Filler<M, A, B> filler, RegistryEntryMeta.RegistryModificationApiSupport support) {
            return new RegistryEntryImpl(new RegistryEntryMeta.Buildable(this.mcKey, this.apiKey, this.classToPreload, this.minecraftToBukkit, this.serializationUpdater, filler, support));
        }
    }
}

