/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.base.Function;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.jtracy.TracyClient;
import com.mojang.jtracy.Zone;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceImmutableList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CharPredicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.TracingExecutor;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SingleKeyCache;
import net.minecraft.util.TimeSource;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.world.level.block.state.properties.IBlockState;
import org.slf4j.Logger;

public class SystemUtils {
    static final Logger g = LogUtils.getLogger();
    private static final int h = 255;
    private static final int i = 10;
    private static final String j = "max.bg.threads";
    private static final TracingExecutor k = SystemUtils.makeExecutor("Main", -1);
    private static final TracingExecutor l = SystemUtils.a("IO-Worker-", false);
    public static final TracingExecutor DIMENSION_DATA_IO_POOL = SystemUtils.makeExtraIoExecutor("Dimension-Data-IO-Worker-");
    private static final TracingExecutor m = SystemUtils.a("Download-", true);
    public static final ExecutorService PROFILE_EXECUTOR = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private final AtomicInteger count = new AtomicInteger();

        @Override
        public Thread newThread(Runnable run) {
            Thread ret = new Thread(run);
            ret.setName("Profile Lookup Executor #" + this.count.getAndIncrement());
            ret.setUncaughtExceptionHandler((thread, throwable) -> g.error("Uncaught exception in thread " + thread.getName(), throwable));
            return ret;
        }
    });
    private static final DateTimeFormatter n = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss", Locale.ROOT);
    public static final int a = 8;
    private static final Set<String> o = Set.of("http", "https");
    public static final long b = 1000000L;
    public static TimeSource.a c = System::nanoTime;
    public static final Ticker d = new BooleanSupplier(){
        final /* synthetic */ Path val$filePath;
        final /* synthetic */ Path val$newName;
        {
            this.val$filePath = path;
            this.val$newName = path2;
        }

        @Override
        public boolean getAsBoolean() {
            try {
                Files.move(this.val$filePath, this.val$newName, new CopyOption[0]);
                return true;
            }
            catch (IOException var2) {
                g.error("Failed to rename", (Throwable)var2);
                return false;
            }
        }

        public String toString() {
            return "rename " + String.valueOf(this.val$filePath) + " to " + String.valueOf(this.val$newName);
        }
    };
    public static final UUID e = new UUID(0L, 0L);
    public static final FileSystemProvider f = FileSystemProvider.installedProviders().stream().filter(provider -> provider.getScheme().equalsIgnoreCase("jar")).findFirst().orElseThrow(() -> new IllegalStateException("No jar file system provider found"));
    private static Consumer<String> p = string -> {};
    public static final double COLLISION_EPSILON = 1.0E-7;

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> a() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T> Collector<T, ?, List<T>> b() {
        return Collectors.toCollection(Lists::newArrayList);
    }

    public static <T extends Comparable<T>> String a(IBlockState<T> property, Object value) {
        return property.b((Comparable)value);
    }

    public static String a(String type, @Nullable MinecraftKey id) {
        return id == null ? type + ".unregistered_sadface" : type + "." + id.b() + "." + id.a().replace('/', '.');
    }

    public static long c() {
        return SystemUtils.d() / 1000000L;
    }

    public static long d() {
        return System.nanoTime();
    }

    public static long e() {
        return Instant.now().toEpochMilli();
    }

    public static String f() {
        return n.format(ZonedDateTime.now());
    }

    private static TracingExecutor makeExecutor(final String name, int priorityModifier) {
        Object directExecutorService;
        int i2 = SystemUtils.g();
        if (i2 <= 0) {
            directExecutorService = MoreExecutors.newDirectExecutorService();
        } else {
            AtomicInteger atomicInteger = new AtomicInteger(1);
            directExecutorService = new ForkJoinPool(i2, forkJoinPool -> {
                final String string = "Worker-" + name + "-" + atomicInteger.getAndIncrement();
                ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                    @Override
                    protected void onStart() {
                        TracyClient.setThreadName((String)string, (int)name.hashCode());
                        super.onStart();
                    }

                    @Override
                    protected void onTermination(Throwable throwOnTermination) {
                        if (throwOnTermination != null) {
                            g.warn("{} died", (Object)this.getName(), (Object)throwOnTermination);
                        } else {
                            g.debug("{} shutdown", (Object)this.getName());
                        }
                        super.onTermination(throwOnTermination);
                    }
                };
                forkJoinWorkerThread.setPriority(5 + priorityModifier);
                forkJoinWorkerThread.setName(string);
                return forkJoinWorkerThread;
            }, SystemUtils::a, true, 0, Integer.MAX_VALUE, 1, null, 365L, TimeUnit.DAYS);
        }
        return new TracingExecutor((ExecutorService)directExecutorService);
    }

    public static int g() {
        int cpus = Runtime.getRuntime().availableProcessors() / 2;
        int maxExecutorThreads = cpus <= 4 ? (cpus <= 2 ? 1 : 2) : (cpus <= 8 ? Math.max(3, cpus - 2) : cpus * 2 / 3);
        maxExecutorThreads = Math.min(8, maxExecutorThreads);
        return Integer.getInteger("Paper.WorkerThreadCount", maxExecutorThreads);
    }

    private static int q() {
        String property = System.getProperty(j);
        if (property != null) {
            try {
                int i2 = Integer.parseInt(property);
                if (i2 >= 1 && i2 <= 255) {
                    return i2;
                }
                g.error("Wrong {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{j, property, 255});
            }
            catch (NumberFormatException var2) {
                g.error("Could not parse {} property value '{}'. Should be an integer value between 1 and {}.", new Object[]{j, property, 255});
            }
        }
        return 255;
    }

    public static TracingExecutor h() {
        return k;
    }

    public static TracingExecutor i() {
        return l;
    }

    public static TracingExecutor j() {
        return m;
    }

    public static void k() {
        k.a(3L, TimeUnit.SECONDS);
        l.a(3L, TimeUnit.SECONDS);
    }

    private static TracingExecutor a(String name, boolean daemon) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new TracingExecutor(Executors.newCachedThreadPool(task -> {
            Thread thread = new Thread(task);
            String string = name + atomicInteger.getAndIncrement();
            TracyClient.setThreadName((String)string, (int)name.hashCode());
            thread.setName(string);
            thread.setDaemon(daemon);
            thread.setUncaughtExceptionHandler(SystemUtils::a);
            return thread;
        }));
    }

    private static TracingExecutor makeExtraIoExecutor(String namePrefix) {
        AtomicInteger atomicInteger = new AtomicInteger(1);
        return new TracingExecutor(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            String string2 = namePrefix + atomicInteger.getAndIncrement();
            TracyClient.setThreadName((String)string2, (int)namePrefix.hashCode());
            thread.setName(string2);
            thread.setDaemon(false);
            thread.setUncaughtExceptionHandler(SystemUtils::a);
            return thread;
        }));
    }

    public static void a(Throwable throwable) {
        throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
    }

    public static void a(Thread thread, Throwable throwable) {
        SystemUtils.b(throwable);
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ReportedException) {
            ReportedException reportedException = (ReportedException)throwable;
            DispenserRegistry.a(reportedException.a().a(ReportType.a));
            System.exit(-1);
        }
        g.error(String.format(Locale.ROOT, "Caught exception in thread %s", thread), throwable);
    }

    @Nullable
    public static Type<?> a(DSL.TypeReference type, String choiceName) {
        return !SharedConstants.aU ? null : SystemUtils.b(type, choiceName);
    }

    @Nullable
    private static Type<?> b(DSL.TypeReference type, String choiceName) {
        Type type1;
        block2: {
            type1 = null;
            try {
                type1 = DataConverterRegistry.a().getSchema(DataFixUtils.makeKey((int)SharedConstants.b().d().c())).getChoiceType(type, choiceName);
            }
            catch (IllegalArgumentException var4) {
                g.error("No data fixer registered for {}", (Object)choiceName);
                if (!SharedConstants.aV) break block2;
                throw var4;
            }
        }
        return type1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(Runnable task, String name) {
        block16: {
            if (SharedConstants.aV) {
                Thread thread = Thread.currentThread();
                String name1 = thread.getName();
                thread.setName(name);
                try (Zone zone = TracyClient.beginZone((String)name, (boolean)SharedConstants.aV);){
                    task.run();
                    break block16;
                }
                finally {
                    thread.setName(name1);
                }
            }
            try (Zone zone1 = TracyClient.beginZone((String)name, (boolean)SharedConstants.aV);){
                task.run();
            }
        }
    }

    public static <T> String a(IRegistry<T> registry, T value) {
        MinecraftKey key = registry.b(value);
        return key == null ? "[unregistered]" : key.toString();
    }

    public static <T> Predicate<T> l() {
        return input -> true;
    }

    public static <T> Predicate<T> a(Predicate<? super T> predicate) {
        return predicate;
    }

    public static <T> Predicate<T> a(Predicate<? super T> predicate1, Predicate<? super T> predicate2) {
        return input -> predicate1.test(input) && predicate2.test(input);
    }

    public static <T> Predicate<T> a(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3) {
        return input -> predicate1.test(input) && predicate2.test(input) && predicate3.test(input);
    }

    public static <T> Predicate<T> a(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3, Predicate<? super T> predicate4) {
        return input -> predicate1.test(input) && predicate2.test(input) && predicate3.test(input) && predicate4.test(input);
    }

    public static <T> Predicate<T> a(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3, Predicate<? super T> predicate4, Predicate<? super T> predicate5) {
        return input -> predicate1.test(input) && predicate2.test(input) && predicate3.test(input) && predicate4.test(input) && predicate5.test(input);
    }

    @SafeVarargs
    public static <T> Predicate<T> a(Predicate<? super T> ... predicates) {
        return input -> {
            for (Predicate predicate : predicates) {
                if (predicate.test(input)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> a(List<? extends Predicate<? super T>> predicates) {
        return switch (predicates.size()) {
            case 0 -> SystemUtils.l();
            case 1 -> SystemUtils.a(predicates.get(0));
            case 2 -> SystemUtils.a(predicates.get(0), predicates.get(1));
            case 3 -> SystemUtils.a(predicates.get(0), predicates.get(1), predicates.get(2));
            case 4 -> SystemUtils.a(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3));
            case 5 -> SystemUtils.a(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3), predicates.get(4));
            default -> {
                Predicate[] predicates1 = (Predicate[])predicates.toArray(Predicate[]::new);
                yield SystemUtils.a(predicates1);
            }
        };
    }

    public static <T> Predicate<T> m() {
        return input -> false;
    }

    public static <T> Predicate<T> b(Predicate<? super T> predicate) {
        return predicate;
    }

    public static <T> Predicate<T> b(Predicate<? super T> predicate1, Predicate<? super T> predicate2) {
        return input -> predicate1.test(input) || predicate2.test(input);
    }

    public static <T> Predicate<T> b(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3) {
        return input -> predicate1.test(input) || predicate2.test(input) || predicate3.test(input);
    }

    public static <T> Predicate<T> b(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3, Predicate<? super T> predicate4) {
        return input -> predicate1.test(input) || predicate2.test(input) || predicate3.test(input) || predicate4.test(input);
    }

    public static <T> Predicate<T> b(Predicate<? super T> predicate1, Predicate<? super T> predicate2, Predicate<? super T> predicate3, Predicate<? super T> predicate4, Predicate<? super T> predicate5) {
        return input -> predicate1.test(input) || predicate2.test(input) || predicate3.test(input) || predicate4.test(input) || predicate5.test(input);
    }

    @SafeVarargs
    public static <T> Predicate<T> b(Predicate<? super T> ... predicates) {
        return input -> {
            for (Predicate predicate : predicates) {
                if (!predicate.test(input)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> b(List<? extends Predicate<? super T>> predicates) {
        return switch (predicates.size()) {
            case 0 -> SystemUtils.m();
            case 1 -> SystemUtils.b(predicates.get(0));
            case 2 -> SystemUtils.b(predicates.get(0), predicates.get(1));
            case 3 -> SystemUtils.b(predicates.get(0), predicates.get(1), predicates.get(2));
            case 4 -> SystemUtils.b(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3));
            case 5 -> SystemUtils.b(predicates.get(0), predicates.get(1), predicates.get(2), predicates.get(3), predicates.get(4));
            default -> {
                Predicate[] predicates1 = (Predicate[])predicates.toArray(Predicate[]::new);
                yield SystemUtils.b(predicates1);
            }
        };
    }

    public static <T> boolean a(int width, int height, List<T> list) {
        if (width == 1) {
            return true;
        }
        int i2 = width / 2;
        for (int i1 = 0; i1 < height; ++i1) {
            for (int i22 = 0; i22 < i2; ++i22) {
                T object1;
                int i3 = width - 1 - i22;
                T object = list.get(i22 + i1 * width);
                if (object.equals(object1 = list.get(i3 + i1 * width))) continue;
                return false;
            }
        }
        return true;
    }

    public static int a(int value, int minValue) {
        return (int)Math.max(Math.min((long)value + (long)(value >> 1), 0x7FFFFFF7L), (long)minValue);
    }

    public static OS n() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return OS.c;
        }
        if (string.contains("mac")) {
            return OS.d;
        }
        if (string.contains("solaris")) {
            return OS.b;
        }
        if (string.contains("sunos")) {
            return OS.b;
        }
        if (string.contains("linux")) {
            return OS.a;
        }
        return string.contains("unix") ? OS.a : OS.e;
    }

    public static URI a(String uri) throws URISyntaxException {
        URI uri1 = new URI(uri);
        String scheme = uri1.getScheme();
        if (scheme == null) {
            throw new URISyntaxException(uri, "Missing protocol in URI: " + uri);
        }
        String string = scheme.toLowerCase(Locale.ROOT);
        if (!o.contains(string)) {
            throw new URISyntaxException(uri, "Unsupported protocol in URI: " + uri);
        }
        return uri1;
    }

    public static Stream<String> o() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMxBean.getInputArguments().stream().filter(argument -> argument.startsWith("-X"));
    }

    public static <T> T c(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T a(Iterable<T> iterable, @Nullable T element) {
        Iterator<T> iterator = iterable.iterator();
        T object = iterator.next();
        if (element != null) {
            T object1 = object;
            while (object1 != element) {
                if (!iterator.hasNext()) continue;
                object1 = iterator.next();
            }
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        return object;
    }

    public static <T> T b(Iterable<T> iterable, @Nullable T current) {
        Iterator<T> iterator = iterable.iterator();
        T object = null;
        while (iterator.hasNext()) {
            T object1 = iterator.next();
            if (object1 == current) {
                if (object != null) break;
                object = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : current);
                break;
            }
            object = object1;
        }
        return object;
    }

    public static <T> T a(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T a(T object, Consumer<? super T> consumer) {
        consumer.accept(object);
        return object;
    }

    public static <K extends Enum<K>, V> Map<K, V> a(Class<K> enumClass, java.util.function.Function<K, V> valueGetter) {
        EnumMap<Enum, V> map = new EnumMap<Enum, V>(enumClass);
        for (Enum _enum : (Enum[])enumClass.getEnumConstants()) {
            map.put(_enum, valueGetter.apply(_enum));
        }
        return map;
    }

    public static <K, V1, V2> Map<K, V2> a(Map<K, V1> map, java.util.function.Function<? super V1, V2> mapper) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> mapper.apply((Object)entry.getValue())));
    }

    public static <K, V1, V2> Map<K, V2> a(Map<K, V1> map, Function<V1, V2> mapper) {
        return Maps.transformValues(map, mapper);
    }

    public static <V> CompletableFuture<List<V>> d(List<? extends CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (futures.size() == 1) {
            return futures.get(0).thenApply(List::of);
        }
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        return completableFuture.thenApply(_void -> futures.stream().map(CompletableFuture::join).toList());
    }

    public static <V> CompletableFuture<List<V>> e(List<? extends CompletableFuture<? extends V>> completableFutures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return SystemUtils.a(completableFutures, completableFuture::completeExceptionally).applyToEither((CompletionStage)completableFuture, java.util.function.Function.identity());
    }

    public static <V> CompletableFuture<List<V>> f(List<? extends CompletableFuture<? extends V>> completableFutures) {
        CompletableFuture completableFuture = new CompletableFuture();
        return SystemUtils.a(completableFutures, (Throwable throwable) -> {
            if (completableFuture.completeExceptionally((Throwable)throwable)) {
                for (CompletableFuture completableFuture1 : completableFutures) {
                    completableFuture1.cancel(true);
                }
            }
        }).applyToEither((CompletionStage)completableFuture, java.util.function.Function.identity());
    }

    private static <V> CompletableFuture<List<V>> a(List<? extends CompletableFuture<? extends V>> completableFutures, Consumer<Throwable> throwableConsumer) {
        ArrayList list = Lists.newArrayListWithCapacity((int)completableFutures.size());
        CompletableFuture[] completableFutures1 = new CompletableFuture[completableFutures.size()];
        completableFutures.forEach(future -> {
            int size = list.size();
            list.add(null);
            completableFutures1[size] = future.whenComplete((result, throwable) -> {
                if (throwable != null) {
                    throwableConsumer.accept((Throwable)throwable);
                } else {
                    list.set(size, result);
                }
            });
        });
        return CompletableFuture.allOf(completableFutures1).thenApply(_void -> list);
    }

    public static <T> Optional<T> a(Optional<T> optional, Consumer<T> ifPresent, Runnable ifEmpty) {
        if (optional.isPresent()) {
            ifPresent.accept(optional.get());
        } else {
            ifEmpty.run();
        }
        return optional;
    }

    public static <T> Supplier<T> a(Supplier<T> item, Supplier<String> nameSupplier) {
        return item;
    }

    public static Runnable a(Runnable item, Supplier<String> nameSupplier) {
        return item;
    }

    public static void b(String error) {
        g.error(error);
        if (SharedConstants.aV) {
            SystemUtils.d(error);
        }
    }

    public static void a(String message, Throwable error) {
        g.error(message, error);
        if (SharedConstants.aV) {
            SystemUtils.d(message);
        }
    }

    public static <T extends Throwable> T b(T throwable) {
        if (SharedConstants.aV) {
            g.error("Trying to throw a fatal exception, pausing in IDE", throwable);
            SystemUtils.d(throwable.getMessage());
        }
        return throwable;
    }

    public static void a(Consumer<String> thePauser) {
        p = thePauser;
    }

    private static void d(String message) {
        boolean flag;
        Instant instant = Instant.now();
        g.warn("Did you remember to set a breakpoint here?");
        boolean bl = flag = Duration.between(instant, Instant.now()).toMillis() > 500L;
        if (!flag) {
            p.accept(message);
        }
    }

    public static String c(Throwable throwable) {
        if (throwable.getCause() != null) {
            return SystemUtils.c(throwable.getCause());
        }
        return throwable.getMessage() != null ? throwable.getMessage() : throwable.toString();
    }

    public static <T> T a(T[] selections, RandomSource random) {
        return selections[random.a(selections.length)];
    }

    public static int a(int[] selections, RandomSource random) {
        return selections[random.a(selections.length)];
    }

    public static <T> T a(List<T> selections, RandomSource random) {
        return selections.get(random.a(selections.size()));
    }

    public static <T> Optional<T> b(List<T> selections, RandomSource random) {
        return selections.isEmpty() ? Optional.empty() : Optional.of(SystemUtils.a(selections, random));
    }

    private static BooleanSupplier a(Path filePath, Path newName) {
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static BooleanSupplier a(final Path filePath) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    Files.deleteIfExists(filePath);
                    return true;
                }
                catch (IOException var2) {
                    g.warn("Failed to delete", (Throwable)var2);
                    return false;
                }
            }

            public String toString() {
                return "delete old " + String.valueOf(filePath);
            }
        };
    }

    private static BooleanSupplier b(final Path filePath) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return !Files.exists(filePath, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(filePath) + " is deleted";
            }
        };
    }

    private static BooleanSupplier c(final Path filePath) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return Files.isRegularFile(filePath, new LinkOption[0]);
            }

            public String toString() {
                return "verify that " + String.valueOf(filePath) + " is present";
            }
        };
    }

    private static boolean a(BooleanSupplier ... suppliers) {
        for (BooleanSupplier booleanSupplier : suppliers) {
            if (booleanSupplier.getAsBoolean()) continue;
            g.warn("Failed to execute {}", (Object)booleanSupplier);
            return false;
        }
        return true;
    }

    private static boolean a(int maxTries, String actionName, BooleanSupplier ... suppliers) {
        for (int i2 = 0; i2 < maxTries; ++i2) {
            if (SystemUtils.a(suppliers)) {
                return true;
            }
            g.error("Failed to {}, retrying {}/{}", new Object[]{actionName, i2, maxTries});
        }
        g.error("Failed to {}, aborting, progress might be lost", (Object)actionName);
        return false;
    }

    public static void a(Path current, Path latest, Path oldBackup) {
        SystemUtils.a(current, latest, oldBackup, false);
    }

    public static boolean a(Path current, Path latest, Path oldBackup, boolean restore) {
        if (Files.exists(current, new LinkOption[0]) && !SystemUtils.a(10, "create backup " + String.valueOf(oldBackup), SystemUtils.a(oldBackup), SystemUtils.a(current, oldBackup), SystemUtils.c(oldBackup))) {
            return false;
        }
        if (!SystemUtils.a(10, "remove old " + String.valueOf(current), SystemUtils.a(current), SystemUtils.b(current))) {
            return false;
        }
        if (!SystemUtils.a(10, "replace " + String.valueOf(current) + " with " + String.valueOf(latest), SystemUtils.a(latest, current), SystemUtils.c(current)) && !restore) {
            SystemUtils.a(10, "restore " + String.valueOf(current) + " from " + String.valueOf(oldBackup), SystemUtils.a(oldBackup, current), SystemUtils.c(current));
            return false;
        }
        return true;
    }

    public static int a(String text, int cursorPos, int direction) {
        int len = text.length();
        if (direction >= 0) {
            for (int i2 = 0; cursorPos < len && i2 < direction; ++i2) {
                if (!Character.isHighSurrogate(text.charAt(cursorPos++)) || cursorPos >= len || !Character.isLowSurrogate(text.charAt(cursorPos))) continue;
                ++cursorPos;
            }
        } else {
            for (int ix = direction; cursorPos > 0 && ix < 0; ++ix) {
                if (!Character.isLowSurrogate(text.charAt(--cursorPos)) || cursorPos <= 0 || !Character.isHighSurrogate(text.charAt(cursorPos - 1))) continue;
                --cursorPos;
            }
        }
        return cursorPos;
    }

    public static Consumer<String> a(String prefix, Consumer<String> expectedSize) {
        return string -> expectedSize.accept(prefix + string);
    }

    public static DataResult<int[]> a(IntStream stream, int size) {
        int[] ints = stream.limit(size + 1).toArray();
        if (ints.length != size) {
            Supplier<String> supplier = () -> "Input is not a list of " + size + " ints";
            return ints.length >= size ? DataResult.error(supplier, (Object)Arrays.copyOf(ints, size)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)ints);
    }

    public static DataResult<long[]> a(LongStream stream, int expectedSize) {
        long[] longs = stream.limit(expectedSize + 1).toArray();
        if (longs.length != expectedSize) {
            Supplier<String> supplier = () -> "Input is not a list of " + expectedSize + " longs";
            return longs.length >= expectedSize ? DataResult.error(supplier, (Object)Arrays.copyOf(longs, expectedSize)) : DataResult.error(supplier);
        }
        return DataResult.success((Object)longs);
    }

    public static <T> DataResult<List<T>> a(List<T> list, int expectedSize) {
        if (list.size() != expectedSize) {
            Supplier<String> supplier = () -> "Input is not a list of " + expectedSize + " elements";
            return list.size() >= expectedSize ? DataResult.error(supplier, list.subList(0, expectedSize)) : DataResult.error(supplier);
        }
        return DataResult.success(list);
    }

    public static void p() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException var2) {
                    g.warn("Timer hack thread interrupted, that really should not happen");
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(g));
        thread.start();
    }

    public static void b(Path fromDirectory, Path toDirectory, Path filePath) throws IOException {
        Path path = fromDirectory.relativize(filePath);
        Path path1 = toDirectory.resolve(path);
        Files.copy(filePath, path1, new CopyOption[0]);
    }

    public static String a(String fileName, CharPredicate characterValidator) {
        return fileName.toLowerCase(Locale.ROOT).chars().mapToObj(i2 -> characterValidator.test((char)i2) ? Character.toString((char)i2) : "_").collect(Collectors.joining());
    }

    public static <K, V> SingleKeyCache<K, V> a(java.util.function.Function<K, V> computeValue) {
        return new SingleKeyCache<K, V>(computeValue);
    }

    public static <T, R> java.util.function.Function<T, R> b(final java.util.function.Function<T, R> memoFunction) {
        return new java.util.function.Function<T, R>(){
            private final Map<T, R> cache = new ConcurrentHashMap();

            @Override
            public R apply(T key) {
                return this.cache.computeIfAbsent(key, memoFunction);
            }

            public String toString() {
                return "memoize/1[function=" + String.valueOf(memoFunction) + ", size=" + this.cache.size() + "]";
            }
        };
    }

    public static <T, U, R> BiFunction<T, U, R> a(final BiFunction<T, U, R> memoBiFunction) {
        return new BiFunction<T, U, R>(){
            private final Map<Pair<T, U>, R> b = new ConcurrentHashMap();

            @Override
            public R apply(T key1, U key2) {
                return this.b.computeIfAbsent(Pair.of(key1, key2), pair -> memoBiFunction.apply(pair.getFirst(), pair.getSecond()));
            }

            public String toString() {
                return "memoize/2[function=" + String.valueOf(memoBiFunction) + ", size=" + this.b.size() + "]";
            }
        };
    }

    public static <T> List<T> a(Stream<T> stream, RandomSource random) {
        ObjectArrayList list = (ObjectArrayList)stream.collect(ObjectArrayList.toList());
        SystemUtils.c(list, random);
        return list;
    }

    public static IntArrayList a(IntStream stream, RandomSource random) {
        int size;
        IntArrayList list = IntArrayList.wrap((int[])stream.toArray());
        for (int i2 = size = list.size(); i2 > 1; --i2) {
            int randomInt = random.a(i2);
            list.set(i2 - 1, list.set(randomInt, list.getInt(i2 - 1)));
        }
        return list;
    }

    public static <T> List<T> b(T[] array, RandomSource random) {
        ObjectArrayList list = new ObjectArrayList((Object[])array);
        SystemUtils.c(list, random);
        return list;
    }

    public static <T> List<T> a(ObjectArrayList<T> list, RandomSource random) {
        ObjectArrayList list1 = new ObjectArrayList(list);
        SystemUtils.c(list1, random);
        return list1;
    }

    public static <T> void c(List<T> list, RandomSource random) {
        int size;
        for (int i2 = size = list.size(); i2 > 1; --i2) {
            int randomInt = random.a(i2);
            list.set(i2 - 1, list.set(randomInt, list.get(i2 - 1)));
        }
    }

    public static <T> CompletableFuture<T> c(java.util.function.Function<Executor, CompletableFuture<T>> task) {
        return SystemUtils.a(task, CompletableFuture::isDone);
    }

    public static <T> T a(java.util.function.Function<Executor, T> task, Predicate<T> donePredicate) {
        int size;
        LinkedBlockingQueue blockingQueue = new LinkedBlockingQueue();
        T object = task.apply(blockingQueue::add);
        while (!donePredicate.test(object)) {
            try {
                Runnable runnable = (Runnable)blockingQueue.poll(100L, TimeUnit.MILLISECONDS);
                if (runnable == null) continue;
                runnable.run();
            }
            catch (InterruptedException var5) {
                g.warn("Interrupted wait");
                break;
            }
        }
        if ((size = blockingQueue.size()) > 0) {
            g.warn("Tasks left in queue: {}", (Object)size);
        }
        return object;
    }

    public static <T> ToIntFunction<T> g(List<T> list) {
        int size = list.size();
        if (size < 8) {
            return list::indexOf;
        }
        Object2IntOpenHashMap map = new Object2IntOpenHashMap(size);
        map.defaultReturnValue(-1);
        for (int i2 = 0; i2 < size; ++i2) {
            map.put(list.get(i2), i2);
        }
        return map;
    }

    public static <T> ToIntFunction<T> h(List<T> list) {
        int size = list.size();
        if (size < 8) {
            ReferenceImmutableList list1 = new ReferenceImmutableList(list);
            return arg_0 -> ((ReferenceList)list1).indexOf(arg_0);
        }
        Reference2IntOpenHashMap map = new Reference2IntOpenHashMap(size);
        map.defaultReturnValue(-1);
        for (int i2 = 0; i2 < size; ++i2) {
            map.put(list.get(i2), i2);
        }
        return map;
    }

    public static <A, B> Typed<B> a(Typed<A> typed, Type<B> type, UnaryOperator<Dynamic<?>> operator) {
        Dynamic dynamic = (Dynamic)((Object)typed.write().getOrThrow());
        return SystemUtils.a(type, (Dynamic)((Object)operator.apply(dynamic)), true);
    }

    public static <T> Typed<T> a(Type<T> type, Dynamic<?> data) {
        return SystemUtils.a(type, data, false);
    }

    public static <T> Typed<T> a(Type<T> type, Dynamic<?> data, boolean partial) {
        DataResult dataResult = type.readTyped(data).map(Pair::getFirst);
        try {
            return partial ? (Typed)dataResult.getPartialOrThrow(IllegalStateException::new) : (Typed)dataResult.getOrThrow(IllegalStateException::new);
        }
        catch (IllegalStateException var7) {
            CrashReport crashReport = CrashReport.a(var7, "Reading type");
            CrashReportSystemDetails crashReportCategory = crashReport.a("Info");
            crashReportCategory.a("Data", data);
            crashReportCategory.a("Type", type);
            throw new ReportedException(crashReport);
        }
    }

    public static <T> List<T> a(List<T> list, T value) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + 1)).addAll(list).add(value).build();
    }

    public static <T> List<T> a(T value, List<T> list) {
        return ImmutableList.builderWithExpectedSize((int)(list.size() + 1)).add(value).addAll(list).build();
    }

    public static <K, V> Map<K, V> a(Map<K, V> map, K key, V value) {
        return ImmutableMap.builderWithExpectedSize((int)(map.size() + 1)).putAll(map).put(key, value).buildKeepingLast();
    }

    public static sealed class OS
    extends Enum<OS> {
        public static final /* enum */ OS a = new OS("linux");
        public static final /* enum */ OS b = new OS("solaris");
        public static final /* enum */ OS c = new OS("windows"){

            @Override
            protected String[] b(URI uri) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", uri.toString()};
            }
        };
        public static final /* enum */ OS d = new OS("mac"){

            @Override
            protected String[] b(URI uri) {
                return new String[]{"open", uri.toString()};
            }
        };
        public static final /* enum */ OS e = new OS("unknown");
        private final String f;
        private static final /* synthetic */ OS[] g;

        public static OS[] values() {
            return (OS[])g.clone();
        }

        public static OS valueOf(String name) {
            return Enum.valueOf(OS.class, name);
        }

        private OS(String telemetryName) {
            this.f = telemetryName;
        }

        public void a(URI uri) {
            throw new IllegalStateException("This method is not useful on dedicated servers.");
        }

        public void a(File file) {
            this.a(file.toURI());
        }

        public void a(Path path) {
            this.a(path.toUri());
        }

        protected String[] b(URI uri) {
            String string = uri.toString();
            if ("file".equals(uri.getScheme())) {
                string = string.replace("file:", "file://");
            }
            return new String[]{"xdg-open", string};
        }

        public void a(String uri) {
            try {
                this.a(new URI(uri));
            }
            catch (IllegalArgumentException | URISyntaxException var3) {
                g.error("Couldn't open uri '{}'", (Object)uri, (Object)var3);
            }
        }

        public String a() {
            return this.f;
        }

        private static /* synthetic */ OS[] b() {
            return new OS[]{a, b, c, d, e};
        }

        static {
            g = OS.b();
        }
    }
}

