/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendCommandsEvent;
import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.PaperBrigadier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.GameTestHarnessTestCommand;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutCommands;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandAdvancement;
import net.minecraft.server.commands.CommandAttribute;
import net.minecraft.server.commands.CommandBan;
import net.minecraft.server.commands.CommandBanIp;
import net.minecraft.server.commands.CommandBanList;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandClear;
import net.minecraft.server.commands.CommandClone;
import net.minecraft.server.commands.CommandDatapack;
import net.minecraft.server.commands.CommandDebug;
import net.minecraft.server.commands.CommandDeop;
import net.minecraft.server.commands.CommandDifficulty;
import net.minecraft.server.commands.CommandEffect;
import net.minecraft.server.commands.CommandEnchant;
import net.minecraft.server.commands.CommandExecute;
import net.minecraft.server.commands.CommandFill;
import net.minecraft.server.commands.CommandForceload;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.commands.CommandGamemodeDefault;
import net.minecraft.server.commands.CommandGamerule;
import net.minecraft.server.commands.CommandGive;
import net.minecraft.server.commands.CommandHelp;
import net.minecraft.server.commands.CommandIdleTimeout;
import net.minecraft.server.commands.CommandKick;
import net.minecraft.server.commands.CommandKill;
import net.minecraft.server.commands.CommandList;
import net.minecraft.server.commands.CommandLocate;
import net.minecraft.server.commands.CommandLoot;
import net.minecraft.server.commands.CommandMe;
import net.minecraft.server.commands.CommandOp;
import net.minecraft.server.commands.CommandPardon;
import net.minecraft.server.commands.CommandPardonIP;
import net.minecraft.server.commands.CommandParticle;
import net.minecraft.server.commands.CommandPlaySound;
import net.minecraft.server.commands.CommandPublish;
import net.minecraft.server.commands.CommandRecipe;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.commands.CommandSaveAll;
import net.minecraft.server.commands.CommandSaveOff;
import net.minecraft.server.commands.CommandSaveOn;
import net.minecraft.server.commands.CommandSay;
import net.minecraft.server.commands.CommandSchedule;
import net.minecraft.server.commands.CommandScoreboard;
import net.minecraft.server.commands.CommandSeed;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.commands.CommandSetWorldSpawn;
import net.minecraft.server.commands.CommandSpawnpoint;
import net.minecraft.server.commands.CommandSpectate;
import net.minecraft.server.commands.CommandSpreadPlayers;
import net.minecraft.server.commands.CommandStop;
import net.minecraft.server.commands.CommandStopSound;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.CommandTag;
import net.minecraft.server.commands.CommandTeam;
import net.minecraft.server.commands.CommandTeamMsg;
import net.minecraft.server.commands.CommandTeleport;
import net.minecraft.server.commands.CommandTell;
import net.minecraft.server.commands.CommandTellRaw;
import net.minecraft.server.commands.CommandTime;
import net.minecraft.server.commands.CommandTitle;
import net.minecraft.server.commands.CommandTrigger;
import net.minecraft.server.commands.CommandWeather;
import net.minecraft.server.commands.CommandWhitelist;
import net.minecraft.server.commands.CommandWorldBorder;
import net.minecraft.server.commands.CommandXp;
import net.minecraft.server.commands.DamageCommand;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.commands.DebugPathCommand;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.RaidCommand;
import net.minecraft.server.commands.RandomCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.server.commands.RideCommand;
import net.minecraft.server.commands.RotateCommand;
import net.minecraft.server.commands.ServerPackCommand;
import net.minecraft.server.commands.SpawnArmorTrimsCommand;
import net.minecraft.server.commands.TickCommand;
import net.minecraft.server.commands.TransferCommand;
import net.minecraft.server.commands.WardenSpawnTrackerCommand;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R4.command.VanillaCommandWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.command.UnknownCommandEvent;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class CommandDispatcher {
    private static final ThreadLocal<ExecutionContext<CommandListenerWrapper>> f = new ThreadLocal();
    private static final Logger g = LogUtils.getLogger();
    public static final int a = 0;
    public static final int b = 1;
    public static final int c = 2;
    public static final int d = 3;
    public static final int e = 4;
    private final com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> h = new com.mojang.brigadier.CommandDispatcher();
    public static final ExecutorService COMMAND_SENDING_POOL = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("Paper Async Command Builder Thread Pool - %1$d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.l)).build(), new ThreadPoolExecutor.DiscardPolicy());

    public CommandDispatcher(ServerType selection, CommandBuildContext context) {
        this(selection, context, false);
    }

    public CommandDispatcher(ServerType selection, CommandBuildContext context, boolean modern) {
        CommandAdvancement.a(this.h);
        CommandAttribute.a(this.h, context);
        CommandExecute.a(this.h, context);
        CommandBossBar.a(this.h, context);
        CommandClear.a(this.h, context);
        CommandClone.a(this.h, context);
        DamageCommand.a(this.h, context);
        CommandData.a(this.h);
        CommandDatapack.a(this.h);
        CommandDebug.a(this.h);
        CommandGamemodeDefault.a(this.h);
        CommandDifficulty.a(this.h);
        CommandEffect.a(this.h, context);
        CommandMe.a(this.h);
        CommandEnchant.a(this.h, context);
        CommandXp.a(this.h);
        CommandFill.a(this.h, context);
        FillBiomeCommand.a(this.h, context);
        CommandForceload.a(this.h);
        CommandFunction.a(this.h);
        CommandGamemode.a(this.h);
        CommandGamerule.a(this.h, context);
        CommandGive.a(this.h, context);
        CommandHelp.a(this.h);
        ItemCommands.a(this.h, context);
        CommandKick.a(this.h);
        CommandKill.a(this.h);
        CommandList.a(this.h);
        CommandLocate.a(this.h, context);
        CommandLoot.a(this.h, context);
        CommandTell.a(this.h);
        CommandParticle.a(this.h, context);
        PlaceCommand.a(this.h);
        CommandPlaySound.a(this.h);
        RandomCommand.a(this.h);
        CommandReload.a(this.h);
        CommandRecipe.a(this.h);
        ReturnCommand.a(this.h);
        RideCommand.a(this.h);
        RotateCommand.a(this.h);
        CommandSay.a(this.h);
        CommandSchedule.a(this.h);
        CommandScoreboard.a(this.h, context);
        CommandSeed.a(this.h, selection != ServerType.c);
        CommandSetBlock.a(this.h, context);
        CommandSpawnpoint.a(this.h);
        CommandSetWorldSpawn.a(this.h);
        CommandSpectate.a(this.h);
        CommandSpreadPlayers.a(this.h);
        CommandStopSound.a(this.h);
        CommandSummon.a(this.h, context);
        CommandTag.a(this.h);
        CommandTeam.a(this.h, context);
        CommandTeamMsg.a(this.h);
        CommandTeleport.a(this.h);
        CommandTellRaw.a(this.h, context);
        GameTestHarnessTestCommand.a(this.h, context);
        TickCommand.a(this.h);
        CommandTime.a(this.h);
        CommandTitle.a(this.h, context);
        CommandTrigger.a(this.h);
        CommandWeather.a(this.h);
        CommandWorldBorder.a(this.h);
        if (JvmProfiler.f.d()) {
            JfrCommand.a(this.h);
        }
        if (SharedConstants.aV) {
            RaidCommand.a(this.h, context);
            DebugPathCommand.a(this.h);
            DebugMobSpawningCommand.a(this.h);
            WardenSpawnTrackerCommand.a(this.h);
            SpawnArmorTrimsCommand.a(this.h);
            ServerPackCommand.a(this.h);
            if (selection.e) {
                DebugConfigCommand.a(this.h);
            }
        }
        if (selection.e) {
            CommandBanIp.a(this.h);
            CommandBanList.a(this.h);
            CommandBan.a(this.h);
            CommandDeop.a(this.h);
            CommandOp.a(this.h);
            CommandPardon.a(this.h);
            CommandPardonIP.a(this.h);
            PerfCommand.a(this.h);
            CommandSaveAll.a(this.h);
            CommandSaveOff.a(this.h);
            CommandSaveOn.a(this.h);
            CommandIdleTimeout.a(this.h);
            CommandStop.a(this.h);
            TransferCommand.a(this.h);
            CommandWhitelist.a(this.h);
        }
        if (selection.d) {
            CommandPublish.a(this.h);
        }
        for (CommandNode node : this.h.getRoot().getChildren()) {
            if (node.getRequirement() != ArgumentBuilder.defaultRequirement()) continue;
            node.requirement = stack -> stack.d == ICommandListener.a || stack.getBukkitSender().hasPermission(VanillaCommandWrapper.getPermission(node));
        }
        for (CommandNode node : new ArrayList(this.h.getRoot().getChildren())) {
            if (modern) {
                this.h.getRoot().addChild(PaperBrigadier.copyLiteral("minecraft:" + node.getName(), (LiteralCommandNode)node));
                continue;
            }
            CommandNode flattenedAliasTarget = node;
            while (flattenedAliasTarget.getRedirect() != null) {
                flattenedAliasTarget = flattenedAliasTarget.getRedirect();
            }
            this.h.register((LiteralArgumentBuilder<CommandListenerWrapper>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)("minecraft:" + node.getName())).executes(flattenedAliasTarget.getCommand())).requires(flattenedAliasTarget.getRequirement())).redirect(flattenedAliasTarget)));
        }
        this.h.setConsumer(ExecutionCommandSource.b_());
    }

    public static <S> ParseResults<S> a(ParseResults<S> parseResults, UnaryOperator<S> mapper) {
        CommandContextBuilder context = parseResults.getContext();
        CommandContextBuilder commandContextBuilder = context.withSource(mapper.apply(context.getSource()));
        return new ParseResults(commandContextBuilder, parseResults.getReader(), parseResults.getExceptions());
    }

    public void dispatchServerCommand(CommandListenerWrapper sender, String command) {
        Joiner joiner = Joiner.on((String)" ");
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        ServerCommandEvent event = new ServerCommandEvent(sender.getBukkitSender(), command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getCommand();
        Object[] args = command.split(" ");
        if (args.length == 0) {
            return;
        }
        String newCommand = joiner.join(args);
        this.performPrefixedCommand(sender, newCommand, newCommand);
    }

    public void a(CommandListenerWrapper source, String command) {
        this.performPrefixedCommand(source, command, command);
    }

    public void performPrefixedCommand(CommandListenerWrapper source, String command, String label) {
        command = command.startsWith("/") ? command.substring(1) : command;
        this.performCommand(this.h.parse(command, source), command, label);
    }

    public void a(ParseResults<CommandListenerWrapper> parseResults, String command) {
        this.performCommand(parseResults, command, command);
    }

    public void performCommand(ParseResults<CommandListenerWrapper> parseResults, String command, String label) {
        this.performCommand(parseResults, command, label, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(ParseResults<CommandListenerWrapper> parseResults, String command, String label, boolean throwCommandError) {
        CommandListenerWrapper commandSourceStack = (CommandListenerWrapper)parseResults.getContext().getSource();
        Profiler.a().a(() -> "/" + command);
        ContextChain<CommandListenerWrapper> contextChain = this.finishParsing(parseResults, command, commandSourceStack, label);
        try {
            if (contextChain != null) {
                CommandDispatcher.a(commandSourceStack, (ExecutionContext<CommandListenerWrapper> executionContext) -> ExecutionContext.a(executionContext, command, contextChain, commandSourceStack, CommandResultCallback.a));
            }
        }
        catch (Exception var12) {
            if (throwCommandError) {
                throw var12;
            }
            IChatMutableComponent mutableComponent = IChatBaseComponent.b(var12.getMessage() == null ? var12.getClass().getName() : var12.getMessage());
            g.error("Command exception: /{}", (Object)command, (Object)var12);
            if (commandSourceStack.l().isDebugging() || g.isDebugEnabled()) {
                StackTraceElement[] stackTrace = var12.getStackTrace();
                for (int i2 = 0; i2 < Math.min(stackTrace.length, 3); ++i2) {
                    mutableComponent.f("\n\n").f(stackTrace[i2].getMethodName()).f("\n ").f(stackTrace[i2].getFileName()).f(":").f(String.valueOf(stackTrace[i2].getLineNumber()));
                }
            }
            commandSourceStack.b(IChatBaseComponent.c("command.failed").a(style -> style.a(new ChatHoverable.e(mutableComponent))));
            if (SharedConstants.aV) {
                commandSourceStack.b(IChatBaseComponent.b(SystemUtils.c(var12)));
                g.error("'/{}' threw an exception", (Object)command, (Object)var12);
            }
        }
        finally {
            Profiler.a().c();
        }
    }

    @Nullable
    private ContextChain<CommandListenerWrapper> finishParsing(ParseResults<CommandListenerWrapper> parseResults, String command, CommandListenerWrapper source, String label) {
        try {
            CommandDispatcher.a(parseResults);
            return (ContextChain)ContextChain.tryFlatten((CommandContext)parseResults.getContext().build(command)).orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseResults.getReader()));
        }
        catch (CommandSyntaxException var7) {
            TextComponent.Builder builder = Component.text();
            ((TextComponent.Builder)builder.color((TextColor)NamedTextColor.RED)).append(MessageComponentSerializer.message().deserialize((Object)var7.getRawMessage()));
            if (var7.getInput() != null && var7.getCursor() >= 0) {
                int min = Math.min(var7.getInput().length(), var7.getCursor());
                IChatMutableComponent mutableComponent = IChatBaseComponent.i().a(EnumChatFormat.h).a(style -> style.a(new ChatClickable.SuggestCommand("/" + label)));
                if (min > 10) {
                    mutableComponent.b(CommonComponents.u);
                }
                mutableComponent.f(var7.getInput().substring(Math.max(0, min - 10), min));
                if (min < var7.getInput().length()) {
                    IChatMutableComponent component = IChatBaseComponent.b(var7.getInput().substring(min)).a(EnumChatFormat.m, EnumChatFormat.t);
                    mutableComponent.b(component);
                }
                mutableComponent.b(IChatBaseComponent.c("command.context.here").a(EnumChatFormat.m, EnumChatFormat.u));
                ((TextComponent.Builder)builder.append((Component)Component.newline())).append(PaperAdventure.asAdventure(mutableComponent));
            }
            UnknownCommandEvent event = new UnknownCommandEvent(source.getBukkitSender(), command, (Component)(SpigotConfig.unknownCommandMessage.isEmpty() ? null : builder.build()));
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.message() != null) {
                source.sendFailure(PaperAdventure.asVanilla(event.message()), false);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(CommandListenerWrapper source, Consumer<ExecutionContext<CommandListenerWrapper>> contextConsumer) {
        block9: {
            boolean flag;
            MinecraftServer server = source.l();
            ExecutionContext<CommandListenerWrapper> executionContext = f.get();
            boolean bl = flag = executionContext == null;
            if (flag) {
                int max = Math.max(1, server.aL().d(GameRules.z));
                int _int = server.aL().d(GameRules.A);
                try (ExecutionContext executionContext1 = new ExecutionContext(max, _int, Profiler.a());){
                    f.set(executionContext1);
                    contextConsumer.accept(executionContext1);
                    executionContext1.a();
                    break block9;
                }
                finally {
                    f.set(null);
                }
            }
            contextConsumer.accept(executionContext);
        }
    }

    public void a(EntityPlayer player) {
        if (SpigotConfig.tabComplete < 0) {
            player.f.b(new PacketPlayOutCommands((RootCommandNode<ICompletionProvider>)new RootCommandNode()));
            return;
        }
        ArrayList commandNodes = new ArrayList(this.h.getRoot().getChildren());
        COMMAND_SENDING_POOL.execute(() -> this.sendAsync(player, commandNodes));
    }

    private void sendAsync(EntityPlayer player, Collection<CommandNode<CommandListenerWrapper>> dispatcherRootChildren) {
        HashMap map = Maps.newHashMap();
        RootCommandNode rootCommandNode = new RootCommandNode();
        map.put(this.h.getRoot(), rootCommandNode);
        this.fillUsableCommands(dispatcherRootChildren, (CommandNode<ICompletionProvider>)rootCommandNode, player.z(), map);
        LinkedHashSet<String> bukkit = new LinkedHashSet<String>();
        for (CommandNode node : rootCommandNode.getChildren()) {
            bukkit.add(node.getName());
        }
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootCommandNode, false).callEvent();
        MinecraftServer.getServer().execute(() -> this.runSync(player, bukkit, (RootCommandNode<ICompletionProvider>)rootCommandNode));
    }

    private void runSync(EntityPlayer player, Collection<String> bukkit, RootCommandNode<ICompletionProvider> rootCommandNode) {
        new AsyncPlayerSendCommandsEvent((Player)player.getBukkitEntity(), rootCommandNode, true).callEvent();
        PlayerCommandSendEvent event = new PlayerCommandSendEvent((Player)player.getBukkitEntity(), new LinkedHashSet<String>(bukkit));
        event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
        for (String orig : bukkit) {
            if (event.getCommands().contains(orig)) continue;
            rootCommandNode.removeCommand(orig);
        }
        player.f.b(new PacketPlayOutCommands(rootCommandNode));
    }

    private void fillUsableCommands(Collection<CommandNode<CommandListenerWrapper>> children, CommandNode<ICompletionProvider> rootSuggestion, CommandListenerWrapper source, Map<CommandNode<CommandListenerWrapper>, CommandNode<ICompletionProvider>> commandNodeToSuggestionNode) {
        for (CommandNode<CommandListenerWrapper> commandNode : children) {
            RequiredArgumentBuilder requiredArgumentBuilder;
            if (commandNode.clientNode != null) {
                commandNode = commandNode.clientNode;
            }
            if (!SpigotConfig.sendNamespaced && commandNode.getName().contains(":") || !commandNode.canUse(source)) continue;
            LiteralArgumentBuilder argumentBuilder = commandNode.createBuilder();
            if (argumentBuilder.getRedirect() != null && commandNodeToSuggestionNode.get(argumentBuilder.getRedirect()) == null) {
                CommandNode<CommandListenerWrapper> redirect = argumentBuilder.getRedirect();
                LiteralArgumentBuilder builder = LiteralArgumentBuilder.literal((String)commandNode.getName());
                builder.requires(redirect.getRequirement());
                if (redirect.getCommand() != null) {
                    builder.executes(redirect.getCommand());
                }
                for (CommandNode<CommandListenerWrapper> child : redirect.getChildren()) {
                    builder.then(child);
                }
                argumentBuilder = builder;
            }
            argumentBuilder.requires(suggestions -> true);
            if (argumentBuilder instanceof RequiredArgumentBuilder && (requiredArgumentBuilder = (RequiredArgumentBuilder)argumentBuilder).getSuggestionsProvider() != null) {
                requiredArgumentBuilder.suggests(CompletionProviders.b((SuggestionProvider<ICompletionProvider>)requiredArgumentBuilder.getSuggestionsProvider()));
            }
            if (argumentBuilder.getRedirect() != null) {
                argumentBuilder.redirect(commandNodeToSuggestionNode.get(argumentBuilder.getRedirect()));
            }
            CommandNode<ICompletionProvider> commandNode1 = argumentBuilder.build();
            commandNodeToSuggestionNode.put(commandNode, commandNode1);
            rootSuggestion.addChild(commandNode1);
            if (commandNode.getChildren().isEmpty()) continue;
            this.fillUsableCommands(commandNode.getChildren(), commandNode1, source, commandNodeToSuggestionNode);
        }
    }

    public static LiteralArgumentBuilder<CommandListenerWrapper> a(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    public static <T> RequiredArgumentBuilder<CommandListenerWrapper, T> a(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public static Predicate<String> a(b parser) {
        return contents -> {
            try {
                parser.parse(new StringReader(contents));
                return true;
            }
            catch (CommandSyntaxException var3) {
                return false;
            }
        };
    }

    public com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> a() {
        return this.h;
    }

    public static <S> void a(ParseResults<S> parseResults) throws CommandSyntaxException {
        CommandSyntaxException parseException = CommandDispatcher.b(parseResults);
        if (parseException != null) {
            throw parseException;
        }
    }

    @Nullable
    public static <S> CommandSyntaxException b(ParseResults<S> result) {
        if (!result.getReader().canRead()) {
            return null;
        }
        if (result.getExceptions().size() == 1) {
            return (CommandSyntaxException)result.getExceptions().values().iterator().next();
        }
        return result.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(result.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(result.getReader());
    }

    public static CommandBuildContext a(final HolderLookup.a provider) {
        return new CommandBuildContext(){

            @Override
            public FeatureFlagSet a() {
                return FeatureFlags.e.a();
            }

            @Override
            public Stream<ResourceKey<? extends IRegistry<?>>> b() {
                return provider.b();
            }

            public <T> Optional<HolderLookup.b<T>> a(ResourceKey<? extends IRegistry<? extends T>> registryKey) {
                return provider.a(registryKey).map(this::a);
            }

            private <T> HolderLookup.b.a<T> a(final HolderLookup.b<T> registryLookup) {
                return new HolderLookup.b.a<T>(){

                    @Override
                    public HolderLookup.b<T> a() {
                        return registryLookup;
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> a(TagKey<T> tagKey) {
                        return Optional.of(this.b(tagKey));
                    }

                    @Override
                    public HolderSet.Named<T> b(TagKey<T> tagKey) {
                        Optional<HolderSet.Named<HolderSet.Named>> optional = this.a().a(tagKey);
                        return optional.orElseGet(() -> HolderSet.a(this.a(), tagKey));
                    }
                };
            }
        };
    }

    public static void b() {
        CommandBuildContext commandBuildContext = CommandDispatcher.a(VanillaRegistries.a());
        com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> dispatcher = new CommandDispatcher(ServerType.a, commandBuildContext).a();
        RootCommandNode<CommandListenerWrapper> root = dispatcher.getRoot();
        dispatcher.findAmbiguities((AmbiguityConsumer<CommandListenerWrapper>)((AmbiguityConsumer)(commandNode, commandNode1, commandNode2, collection) -> g.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{dispatcher.getPath(commandNode1), dispatcher.getPath(commandNode2), collection})));
        Set<ArgumentType<?>> set = ArgumentUtils.a(root);
        Set set1 = set.stream().filter(argumentType -> !ArgumentTypeInfos.a(argumentType.getClass())).collect(Collectors.toSet());
        if (!set1.isEmpty()) {
            g.warn("Missing type registration for following arguments:\n {}", (Object)set1.stream().map(argumentType -> "\t" + String.valueOf(argumentType)).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static final class ServerType
    extends Enum<ServerType> {
        public static final /* enum */ ServerType a = new ServerType(true, true);
        public static final /* enum */ ServerType b = new ServerType(false, true);
        public static final /* enum */ ServerType c = new ServerType(true, false);
        final boolean d;
        final boolean e;
        private static final /* synthetic */ ServerType[] f;

        public static ServerType[] values() {
            return (ServerType[])f.clone();
        }

        public static ServerType valueOf(String name) {
            return Enum.valueOf(ServerType.class, name);
        }

        private ServerType(boolean includeIntegrated, boolean includeDedicated) {
            this.d = includeIntegrated;
            this.e = includeDedicated;
        }

        private static /* synthetic */ ServerType[] a() {
            return new ServerType[]{a, b, c};
        }

        static {
            f = ServerType.a();
        }
    }

    @FunctionalInterface
    public static interface b {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

