/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import io.papermc.paper.command.brigadier.PaperCommandSourceStack;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.ICommandListener;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.command.VanillaCommandWrapper;
import org.spigotmc.SpigotConfig;

public class CommandListenerWrapper
implements ExecutionCommandSource<CommandListenerWrapper>,
ICompletionProvider,
PaperCommandSourceStack {
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("permissions.requires.player"));
    public static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("permissions.requires.entity"));
    public final ICommandListener d;
    private final Vec3D e;
    private final WorldServer f;
    private final int g;
    private final String h;
    private final IChatBaseComponent i;
    private final MinecraftServer j;
    private final boolean k;
    @Nullable
    private final Entity l;
    private final CommandResultCallback m;
    private final ArgumentAnchor.Anchor n;
    private final Vec2F o;
    private final CommandSigningContext p;
    private final TaskChainer q;
    public Map<Thread, CommandNode> currentCommand = new ConcurrentHashMap<Thread, CommandNode>();
    public boolean bypassSelectorPermissions = false;

    public CommandListenerWrapper(ICommandListener source, Vec3D worldPosition, Vec2F rotation, WorldServer level, int permissionLevel, String textName, IChatBaseComponent displayName, MinecraftServer server, @Nullable Entity entity) {
        this(source, worldPosition, rotation, level, permissionLevel, textName, displayName, server, entity, false, CommandResultCallback.a, ArgumentAnchor.Anchor.a, CommandSigningContext.a, TaskChainer.immediate(server));
    }

    protected CommandListenerWrapper(ICommandListener source, Vec3D worldPosition, Vec2F rotation, WorldServer level, int permissionLevel, String textName, IChatBaseComponent displayName, MinecraftServer server, @Nullable Entity entity, boolean silent, CommandResultCallback resultCallback, ArgumentAnchor.Anchor anchor, CommandSigningContext signingContext, TaskChainer chatMessageChainer) {
        this.d = source;
        this.e = worldPosition;
        this.f = level;
        this.k = silent;
        this.l = entity;
        this.g = permissionLevel;
        this.h = textName;
        this.i = displayName;
        this.j = server;
        this.m = resultCallback;
        this.n = anchor;
        this.o = rotation;
        this.p = signingContext;
        this.q = chatMessageChainer;
    }

    public CommandListenerWrapper a(ICommandListener source) {
        return this.d == source ? this : new CommandListenerWrapper(source, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Entity entity) {
        return this.l == entity ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, entity.ah().getString(), entity.P_(), this.j, entity, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Vec3D pos) {
        return this.e.equals(pos) ? this : new CommandListenerWrapper(this.d, pos, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper withLocation(Location location) {
        return this.getLocation().equals((Object)location) ? this : new CommandListenerWrapper(this.d, new Vec3D(location.x(), location.y(), location.z()), new Vec2F(location.getPitch(), location.getYaw()), ((CraftWorld)location.getWorld()).getHandle(), this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Vec2F rotation) {
        return this.o.c(rotation) ? this : new CommandListenerWrapper(this.d, this.e, rotation, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(CommandResultCallback callback) {
        return Objects.equals(this.m, callback) ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, callback, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(CommandResultCallback callback, BinaryOperator<CommandResultCallback> operator) {
        CommandResultCallback commandResultCallback = (CommandResultCallback)operator.apply(this.m, callback);
        return this.a(commandResultCallback);
    }

    public CommandListenerWrapper a() {
        return !this.k && !this.d.o_() ? new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, true, this.m, this.n, this.p, this.q) : this;
    }

    public CommandListenerWrapper a(int permissionLevel) {
        return permissionLevel == this.g ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, permissionLevel, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper b(int permissionLevel) {
        return permissionLevel <= this.g ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, permissionLevel, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(ArgumentAnchor.Anchor anchor) {
        return anchor == this.n ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, anchor, this.p, this.q);
    }

    public CommandListenerWrapper a(WorldServer level) {
        if (level == this.f) {
            return this;
        }
        double teleportationScale = DimensionManager.a(this.f.F_(), level.F_());
        Vec3D vec3 = new Vec3D(this.e.d * teleportationScale, this.e.e, this.e.f * teleportationScale);
        return new CommandListenerWrapper(this.d, vec3, this.o, level, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, this.p, this.q);
    }

    public CommandListenerWrapper a(Entity entity, ArgumentAnchor.Anchor anchor) {
        return this.b(anchor.a(entity));
    }

    public CommandListenerWrapper b(Vec3D lookPos) {
        Vec3D vec3 = this.n.a(this);
        double d2 = lookPos.d - vec3.d;
        double d1 = lookPos.e - vec3.e;
        double d22 = lookPos.f - vec3.f;
        double squareRoot = Math.sqrt(d2 * d2 + d22 * d22);
        float f2 = MathHelper.h((float)(-(MathHelper.d(d1, squareRoot) * 180.0 / 3.1415927410125732)));
        float f1 = MathHelper.h((float)(MathHelper.d(d22, d2) * 180.0 / 3.1415927410125732) - 90.0f);
        return this.a(new Vec2F(f2, f1));
    }

    public CommandListenerWrapper a(CommandSigningContext signingContext, TaskChainer chatMessageChainer) {
        return signingContext == this.p && chatMessageChainer == this.q ? this : new CommandListenerWrapper(this.d, this.e, this.o, this.f, this.g, this.h, this.i, this.j, this.l, this.k, this.m, this.n, signingContext, chatMessageChainer);
    }

    public IChatBaseComponent b() {
        return this.i;
    }

    public String c() {
        return this.h;
    }

    @Override
    public boolean c(int level) {
        CommandNode currentCommand = this.currentCommand.get(Thread.currentThread());
        if (currentCommand != null) {
            return this.hasPermission(level, VanillaCommandWrapper.getPermission(currentCommand));
        }
        return this.g >= level;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean forceRespectPermissionLevel() {
        if (this.d == ICommandListener.a) return true;
        ICommandListener iCommandListener = this.d;
        if (!(iCommandListener instanceof CommandBlockListenerAbstract)) return false;
        CommandBlockListenerAbstract commandBlock = (CommandBlockListenerAbstract)iCommandListener;
        if (!commandBlock.e().paperConfig().commandBlocks.forceFollowPermLevel) return false;
        return true;
    }

    public boolean hasPermission(int i2, String bukkitPermission) {
        BooleanSupplier hasBukkitPerm = () -> this.d == ICommandListener.a || this.getBukkitSender().hasPermission(bukkitPermission);
        if (this.l() == null || !this.l().server.ignoreVanillaPermissions) {
            boolean hasPermLevel;
            boolean bl = hasPermLevel = this.g >= i2;
            if (this.forceRespectPermissionLevel()) {
                return hasPermLevel && hasBukkitPerm.getAsBoolean();
            }
            return hasPermLevel || hasBukkitPerm.getAsBoolean();
        }
        return hasBukkitPerm.getAsBoolean();
    }

    public Vec3D d() {
        return this.e;
    }

    public WorldServer e() {
        return this.f;
    }

    @Nullable
    public Entity f() {
        return this.l;
    }

    public Entity g() throws CommandSyntaxException {
        if (this.l == null) {
            throw b.create();
        }
        return this.l;
    }

    public EntityPlayer h() throws CommandSyntaxException {
        Entity entity = this.l;
        if (entity instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)entity;
            return serverPlayer;
        }
        throw a.create();
    }

    @Nullable
    public EntityPlayer i() {
        EntityPlayer serverPlayer;
        Entity entity = this.l;
        return entity instanceof EntityPlayer ? (serverPlayer = (EntityPlayer)entity) : null;
    }

    public boolean j() {
        return this.l instanceof EntityPlayer;
    }

    public Vec2F k() {
        return this.o;
    }

    public MinecraftServer l() {
        return this.j;
    }

    public ArgumentAnchor.Anchor m() {
        return this.n;
    }

    public CommandSigningContext n() {
        return this.p;
    }

    public TaskChainer o() {
        return this.q;
    }

    public boolean a(EntityPlayer receiver) {
        EntityPlayer player = this.i();
        return receiver != player && (player != null && player.W() || receiver.W());
    }

    public void a(OutgoingChatMessage message, boolean shouldFilter, ChatMessageType.a boundChatType) {
        if (!this.k) {
            EntityPlayer player = this.i();
            if (player != null) {
                player.a(message, shouldFilter, boundChatType);
            } else {
                this.d.a(boundChatType.a(message.a()));
            }
        }
    }

    public void a(IChatBaseComponent message) {
        if (!this.k) {
            EntityPlayer player = this.i();
            if (player != null) {
                player.a(message);
            } else {
                this.d.a(message);
            }
        }
    }

    public void a(Supplier<IChatBaseComponent> messageSupplier, boolean allowLogging) {
        boolean flag1;
        boolean flag = this.d.x_() && !this.k;
        boolean bl = flag1 = allowLogging && this.d.c() && !this.k;
        if (flag || flag1) {
            IChatBaseComponent component = messageSupplier.get();
            if (flag) {
                this.d.a(component);
            }
            if (flag1) {
                this.c(component);
            }
        }
    }

    private void c(IChatBaseComponent message) {
        IChatMutableComponent component = IChatBaseComponent.a("chat.type.admin", this.b(), message).a(EnumChatFormat.h, EnumChatFormat.u);
        if (this.j.aL().c(GameRules.q)) {
            for (EntityPlayer serverPlayer : this.j.ag().t()) {
                if (serverPlayer.y() == this.d || !serverPlayer.getBukkitEntity().hasPermission("minecraft.admin.command_feedback")) continue;
                serverPlayer.a(component);
            }
        }
        if (this.d != this.j && this.j.aL().c(GameRules.n) && !SpigotConfig.silentCommandBlocks) {
            this.j.a(component);
        }
    }

    public void b(IChatBaseComponent message) {
        this.sendFailure(message, true);
    }

    public void sendFailure(IChatBaseComponent message, boolean withStyle) {
        if (this.d.y_() && !this.k) {
            this.d.a(withStyle ? IChatBaseComponent.i().b(message).a(EnumChatFormat.m) : message);
        }
    }

    @Override
    public CommandResultCallback p() {
        return this.m;
    }

    @Override
    public Collection<String> q() {
        EntityPlayer sourcePlayer;
        Entity entity = this.l;
        return entity instanceof EntityPlayer && !(sourcePlayer = (EntityPlayer)entity).getBukkitEntity().hasPermission("paper.bypass-visibility.tab-completion") ? this.l().ag().t().stream().filter(serverPlayer -> sourcePlayer.getBukkitEntity().canSee(serverPlayer.getBukkitEntity())).map(serverPlayer -> serverPlayer.gi().getName()).toList() : Lists.newArrayList((Object[])this.j.P());
    }

    @Override
    public Collection<String> r() {
        return this.j.aJ().e();
    }

    @Override
    public Stream<MinecraftKey> s() {
        return BuiltInRegistries.b.s().map(SoundEffect::a);
    }

    @Override
    public CompletableFuture<Suggestions> a(CommandContext<?> context) {
        return Suggestions.empty();
    }

    @Override
    public CompletableFuture<Suggestions> a(ResourceKey<? extends IRegistry<?>> resourceKey, ICompletionProvider.a registryKey, SuggestionsBuilder builder, CommandContext<?> context) {
        if (resourceKey == Registries.bv) {
            return ICompletionProvider.a(this.j.aI().d().stream().map(recipeHolder -> recipeHolder.a().a()), builder);
        }
        if (resourceKey == Registries.bu) {
            Collection<AdvancementHolder> allAdvancements = this.j.aD().b();
            return ICompletionProvider.a(allAdvancements.stream().map(AdvancementHolder::a), builder);
        }
        return this.u().a(resourceKey).map(registry -> {
            this.a((IRegistry<?>)registry, registryKey, builder);
            return builder.buildFuture();
        }).orElseGet(Suggestions::empty);
    }

    @Override
    public Set<ResourceKey<World>> t() {
        return this.j.K();
    }

    @Override
    public IRegistryCustom u() {
        return this.j.ba();
    }

    @Override
    public FeatureFlagSet v() {
        return this.f.K();
    }

    @Override
    public CommandDispatcher<CommandListenerWrapper> w() {
        return this.l().aE().a();
    }

    @Override
    public void a(CommandExceptionType exceptionType, Message message, boolean success, @Nullable TraceCallbacks traceCallbacks) {
        if (traceCallbacks != null) {
            traceCallbacks.a(message.getString());
        }
        if (!success) {
            this.b(ChatComponentUtils.a(message));
        }
    }

    @Override
    public boolean x() {
        return this.k;
    }

    @Override
    public CommandListenerWrapper getHandle() {
        return this;
    }

    @Override
    public CommandSender getBukkitSender() {
        return this.d.getBukkitSender(this);
    }
}

