/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.scores.ScoreAccess;

public class ArgumentMathOperation
implements ArgumentType<a> {
    private static final Collection<String> a = Arrays.asList("=", ">", "<");
    private static final SimpleCommandExceptionType b = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.operation.invalid"));
    private static final SimpleCommandExceptionType c = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("arguments.operation.div0"));

    public static ArgumentMathOperation a() {
        return new ArgumentMathOperation();
    }

    public static a a(CommandContext<CommandListenerWrapper> context, String name) {
        return (a)context.getArgument(name, a.class);
    }

    public a a(StringReader reader) throws CommandSyntaxException {
        if (!reader.canRead()) {
            throw b.createWithContext((ImmutableStringReader)reader);
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        return ArgumentMathOperation.a(reader.getString().substring(cursor, reader.getCursor()));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ICompletionProvider.a(new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, builder);
    }

    public Collection<String> getExamples() {
        return a;
    }

    private static a a(String name) throws CommandSyntaxException {
        return name.equals("><") ? (targetScore, sourceScore) -> {
            int i2 = targetScore.a();
            targetScore.a(sourceScore.a());
            sourceScore.a(i2);
        } : ArgumentMathOperation.b(name);
    }

    private static b b(String name) throws CommandSyntaxException {
        return switch (name) {
            case "=" -> (targetScore, sourceScore) -> sourceScore;
            case "+=" -> Integer::sum;
            case "-=" -> (targetScore, sourceScore) -> targetScore - sourceScore;
            case "*=" -> (targetScore, sourceScore) -> targetScore * sourceScore;
            case "/=" -> (targetScore, sourceScore) -> {
                if (sourceScore == 0) {
                    throw c.create();
                }
                return MathHelper.a(targetScore, sourceScore);
            };
            case "%=" -> (targetScore, sourceScore) -> {
                if (sourceScore == 0) {
                    throw c.create();
                }
                return MathHelper.b(targetScore, sourceScore);
            };
            case "<" -> Math::min;
            case ">" -> Math::max;
            default -> throw b.create();
        };
    }

    @FunctionalInterface
    public static interface a {
        public void apply(ScoreAccess var1, ScoreAccess var2) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface b
    extends a {
        public int apply(int var1, int var2) throws CommandSyntaxException;

        @Override
        default public void apply(ScoreAccess targetScore, ScoreAccess sourceScore) throws CommandSyntaxException {
            targetScore.a(this.apply(targetScore.a(), sourceScore.a()));
        }
    }
}

