/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;

public class ArgumentProfile
implements ArgumentType<a> {
    private static final Collection<String> b = Arrays.asList("Player", "0123", "dd12be42-52a9-4a91-a8a1-11c01849e498", "@e");
    public static final SimpleCommandExceptionType a = new SimpleCommandExceptionType((Message)IChatBaseComponent.c("argument.player.unknown"));

    public static Collection<GameProfile> a(CommandContext<CommandListenerWrapper> context, String name) throws CommandSyntaxException {
        return ((a)context.getArgument(name, a.class)).getNames((CommandListenerWrapper)context.getSource());
    }

    public static ArgumentProfile a() {
        return new ArgumentProfile();
    }

    public <S> a a(StringReader reader, S suggestionProvider) throws CommandSyntaxException {
        return ArgumentProfile.a(reader, ArgumentParserSelector.a(suggestionProvider));
    }

    public a a(StringReader reader) throws CommandSyntaxException {
        return ArgumentProfile.a(reader, true);
    }

    private static a a(StringReader reader, boolean allowSelectors) throws CommandSyntaxException {
        if (reader.canRead() && reader.peek() == '@') {
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(reader, allowSelectors);
            EntitySelector entitySelector = entitySelectorParser.t();
            if (entitySelector.b()) {
                throw ArgumentEntity.c.createWithContext((ImmutableStringReader)reader);
            }
            return new b(entitySelector);
        }
        int cursor = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        String sub = reader.getString().substring(cursor, reader.getCursor());
        return source -> {
            Optional<GameProfile> optional = source.l().at().a(sub);
            return Collections.singleton(optional.orElseThrow(() -> ((SimpleCommandExceptionType)a).create()));
        };
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof ICompletionProvider) {
            ICompletionProvider sharedSuggestionProvider = (ICompletionProvider)object;
            StringReader stringReader = new StringReader(builder.getInput());
            stringReader.setCursor(builder.getStart());
            ArgumentParserSelector entitySelectorParser = new ArgumentParserSelector(stringReader, ArgumentParserSelector.a(sharedSuggestionProvider));
            try {
                entitySelectorParser.t();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entitySelectorParser.a(builder, suggestionsBuilder -> ICompletionProvider.b(sharedSuggestionProvider.q(), suggestionsBuilder));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return b;
    }

    @FunctionalInterface
    public static interface a {
        public Collection<GameProfile> getNames(CommandListenerWrapper var1) throws CommandSyntaxException;
    }

    public static class b
    implements a {
        private final EntitySelector a;

        public b(EntitySelector selector) {
            this.a = selector;
        }

        @Override
        public Collection<GameProfile> getNames(CommandListenerWrapper source) throws CommandSyntaxException {
            List<EntityPlayer> list = this.a.d(source);
            if (list.isEmpty()) {
                throw ArgumentEntity.e.create();
            }
            ArrayList list1 = Lists.newArrayList();
            for (EntityPlayer serverPlayer : list) {
                list1.add(serverPlayer.gi());
            }
            return list1;
        }
    }
}

