/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class ArgumentScoreboardCriteria
implements ArgumentType<IScoreboardCriteria> {
    private static final Collection<String> b = Arrays.asList("foo", "foo.bar.baz", "minecraft:foo");
    public static final DynamicCommandExceptionType a = new DynamicCommandExceptionType(criterion -> IChatBaseComponent.b("argument.criteria.invalid", criterion));

    private ArgumentScoreboardCriteria() {
    }

    public static ArgumentScoreboardCriteria a() {
        return new ArgumentScoreboardCriteria();
    }

    public static IScoreboardCriteria a(CommandContext<CommandListenerWrapper> context, String name) {
        return (IScoreboardCriteria)context.getArgument(name, IScoreboardCriteria.class);
    }

    public IScoreboardCriteria a(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        while (reader.canRead() && reader.peek() != ' ') {
            reader.skip();
        }
        String sub = reader.getString().substring(cursor, reader.getCursor());
        return IScoreboardCriteria.a(sub).orElseThrow(() -> {
            reader.setCursor(cursor);
            return a.createWithContext((ImmutableStringReader)reader, (Object)sub);
        });
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        ArrayList list = Lists.newArrayList(IScoreboardCriteria.c());
        for (StatisticWrapper statisticWrapper : BuiltInRegistries.v) {
            for (Object object : statisticWrapper.b()) {
                String name = this.a(statisticWrapper, object);
                list.add(name);
            }
        }
        return ICompletionProvider.b(list, builder);
    }

    public <T> String a(StatisticWrapper<T> type, Object value) {
        return Statistic.a(type, value);
    }

    public Collection<String> getExamples() {
        return b;
    }
}

